<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
                exclude-result-prefixes="xsl datetime exslt xsi" xmlns:dri="http://www.driver-repository.eu/namespace/dri">

	<xsl:param name="datasourceId"/>

	<xsl:template match="/">
		<record xmlns:dri="http://www.driver-repository.eu/namespace/dri">
			<header>
				<dri:objIdentifier>
					<xsl:value-of select="concat($datasourceId, '::', normalize-space(//FIELD[@name='_dnet_resource_identifier_']))"/>
				</dri:objIdentifier>
				<dri:dateOfCollection>
					<xsl:value-of select="datetime:dateTime()"/>
				</dri:dateOfCollection>
				<dri:repositoryId>
					<xsl:value-of select="$datasourceId"/>
				</dri:repositoryId>
			</header>
			<metadata>
				<xsl:copy-of select="."/>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>