/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class PrepareStatsParamJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareStatsParamJobNode.class);
    private static final String xqueryIsLookupEndpoint = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IS_LookUpServiceResourceType']//PROTOCOL[./@name='SOAP']/@address/string()";
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    protected ConfigurationEnumerator configurationEnumerator;

    protected String execute(NodeToken token) throws Exception {
        log.info((Object)"prepare stats update job");
        Configuration conf = this.configurationEnumerator.get(ClusterName.DM);
        String nameNode = conf.get("fs.defaultFS");
        token.getEnv().setAttribute("nameNode", nameNode);
        token.getEnv().setAttribute("jobTracker", conf.get("mapred.job.tracker"));
        token.getEnv().setAttribute("isLookupEndpoint", this.getIsLookupEndpoint());
        return Arc.DEFAULT_ARC;
    }

    private String getIsLookupEndpoint() throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xqueryIsLookupEndpoint);
    }
}

