package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class UpdateSetsJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(UpdateSetsJobNode.class);
	public static final String SET_UPDATED = "updated";
	public static final String SET_ENABLED = "enabled";
	public static final String SETS_ENV_ATTRIBUTE = "sets";

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final Gson gson = new Gson();
		final List<Map<String, String>> sets = gson.fromJson(token.getEnv().getAttribute(SETS_ENV_ATTRIBUTE), List.class);

		final String lastUpdate = DateUtils.now_ISO8601();
		for (Map<String, String> set : sets) {

			// update only the enabled sets that were not yet updated.
			if (isEnabled(set) && !isSetUpdated(set)) {
				log.info("updating set: " + set.toString());
				addLatestRawSet(set, lastUpdate);
			} else {
				log.info("skip set update: " + set.toString());
			}
		}

		token.getEnv().setAttribute(SETS_ENV_ATTRIBUTE, gson.toJson(sets));

		return Arc.DEFAULT_ARC;
	}

	private boolean isEnabled(final Map<String, String> set) {
		return set.containsKey(SET_ENABLED) && set.get(SET_ENABLED).equals("true");
	}

	private boolean isSetUpdated(final Map<String, String> set) {
		return set.containsKey(SET_UPDATED) && set.get(SET_UPDATED).equals("true");
	}

	public void addLatestRawSet(final Map<String, String> set, final String lastUpdate) throws MSROException {
		final String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//SET/@id = '" + set.get("set")
				+ "' return $x";
		try {
			final String profile = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(q);
			final Document doc = new SAXReader().read(new StringReader(profile));
			final String profId = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
			final Element latest = (Element) doc.selectSingleNode("//RAW_SETS/LATEST");
			final Element expired = ((Element) doc.selectSingleNode("//RAW_SETS")).addElement("EXPIRED");

			for (Object o : latest.attributes()) {
				final Attribute a = (Attribute) o;
				expired.addAttribute(a.getName(), a.getValue());
			}

			latest.addAttribute("id", set.get("rawset"));
			latest.addAttribute("creationDate", set.get("creationDate"));
			latest.addAttribute("lastUpdate", lastUpdate);

			serviceLocator.getService(ISRegistryService.class).updateProfile(profId, doc.asXML(), "ActionManagerSetDSResourceType");

			// mark the set profile update as completed
			set.put(SET_UPDATED, "true");
		} catch (Exception e) {
			String msg = "Error updating profile of set: " + set;
			log.error(msg);
			throw new MSROException(msg, e);
		}
	}

}
