package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.openaireplus.workflows.nodes.index.ContextLoader;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LoadContextsJobNode extends SimpleJobNode {

	public static final String CONTEXTMAP = "contextmap";

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(LoadContextsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private ContextLoader contextLoader;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		log.info("start preparing job");

		String contexts = contextLoader.load();

		if (StringUtils.isBlank(contexts)) throw new MSROException("empty contexts");

		token.getEnv().setAttribute(CONTEXTMAP, contexts);

		return Arc.DEFAULT_ARC;
	}

}
