<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="fn">

    <xsl:variable name="namespacePrefix" select="string('ukri________')"/>
    <xsl:variable name="funderID" select="concat($namespacePrefix, '::UKRI')"/>

    <xsl:template match="/">
        <xsl:variable name="funding" select="//funder/name"/>
        <fundingtree>
            <funder>
                <id>
                    <xsl:value-of select="$funderID"/>
                </id>
                <shortname>UKRI</shortname>
                <name>UK Research and Innovation</name>
                <jurisdiction>GB</jurisdiction>
            </funder>
            <xsl:if test="string-length($funding) > 0">
                <funding_level_0>
                    <id>
                        <xsl:value-of select="concat($funderID, '::', $funding)"/>
                    </id>
                    <description>
                        <xsl:value-of select="$funding"/>
                    </description>
                    <name>
                        <xsl:value-of select="$funding"/>
                    </name>
                    <parent></parent>
                    <class>ukri:fundingStream</class>
                </funding_level_0>
            </xsl:if>
        </fundingtree>
    </xsl:template>
</xsl:stylesheet>