<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="PREPARE_DB"/>
		<ARC to="obtainParams"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Obtain parameters for current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="generateRow"/>
	</ARCS>
</NODE>

<NODE name="PREPARE_DB" type="ExecuteSql">
	<DESCRIPTION>Create necessary tables</DESCRIPTION>
    <PARAMETERS>
    	<PARAM name="dbProperty" type="string" managedBy="system" required="true">dnet.openaire.db.name</PARAM>
        <PARAM name="sql" type="string" managedBy="system" required="true">/eu/dnetlib/msro/openaireplus/workflows/repo-hi/hostedbyMapJournalIntersection/sql/pangaea_preparetable.sql</PARAM>
	</PARAMETERS>
    <ARCS>
		<ARC to="COLLECT"/>		
	</ARCS>
</NODE>

<NODE name="COLLECT" type="CollectRecords">
	<DESCRIPTION>Start Harvesting</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">collected_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="generateRow"/>
	</ARCS>
</NODE>

<NODE name="generateRow" type="ApplyXslt" isJoin="true">
	<DESCRIPTION>Transform original records to Publication</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="user" function="listFiles('/eu/dnetlib/msro/openaireplus/workflows/repo-hi/hostedbyMapJournalIntersection/xsl','xsl')"></PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">collected_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">row_epr</PARAM>		 
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_JORUNAL_DB"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_JORUNAL_DB" type="UpdateOpenaireDb">
	<DESCRIPTION>Update Db</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">row_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="FIND_MATCHES"/>
	</ARCS>
</NODE>

<NODE name="FIND_MATCHES" type="ExecuteSql">
	<DESCRIPTION>Add new journal to patch entry tables</DESCRIPTION>
    <PARAMETERS>
    	<PARAM name="dbProperty" type="string" managedBy="system" required="true">dnet.openaire.db.name</PARAM>
        <PARAM name="sql" type="string" managedBy="user" required="true" function="listFiles('/eu/dnetlib/msro/openaireplus/workflows/repo-hi/hostedbyMapJournalIntersection/sql','sql')"></PARAM>
	</PARAMETERS>
    <ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>