package eu.dnetlib.msro.openaireplus.workflows.nodes.dhp;

import javax.annotation.Resource;

import eu.dnetlib.dhp.schema.mdstore.MDStoreWithInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.client.RestTemplate;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class CreateMDStoreHadoopJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(CreateMDStoreHadoopJobNode.class);
	public static final String MDSTORE_CREATE_URL_AND_PARAMS = "/new/{format}/{layout}/{interpretation}?dsName={dsName}&dsId={dsid}&apiId={apiId}";

	/* Workflow params */
	private String format;
	private String layout;
	private String interpretation;
	private String outputPrefix = "mdstore";

	/* Spring managed params */
	private String mdStoreManagerUrl;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final String openAireDataSourceId = token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_ID);

		final String urlTemplate = getMdStoreManagerUrl() + MDSTORE_CREATE_URL_AND_PARAMS;

		final RestTemplate restTemplate = new RestTemplate();
		final MDStoreWithInfo result =
			restTemplate.getForObject(urlTemplate, MDStoreWithInfo.class, getFormat(), getLayout(), getInterpretation(), token.getFullEnv()
				.getAttribute(WorkflowsConstants.DATAPROVIDER_NAME), openAireDataSourceId, token.getFullEnv()
					.getAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE));

		log.info("created mdstore: " + new Gson().toJson(result));

		token.getEnv().setAttribute(getOutputPrefix() + "format", format);
		token.getEnv().setAttribute(getOutputPrefix() + "layout", layout);
		token.getEnv().setAttribute(getOutputPrefix() + "interpretation", interpretation);
		token.getEnv().setAttribute(getOutputPrefix() + "id", result.getId());

		return Arc.DEFAULT_ARC;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(final String format) {
		this.format = format;
	}

	public String getLayout() {
		return layout;
	}

	public void setLayout(final String layout) {
		this.layout = layout;
	}

	public String getInterpretation() {
		return interpretation;
	}

	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

	public String getOutputPrefix() {
		return outputPrefix;
	}

	public void setOutputPrefix(final String outputPrefix) {
		this.outputPrefix = outputPrefix;
	}

	public String getMdStoreManagerUrl() {
		return mdStoreManagerUrl;
	}

	@Required
	public void setMdStoreManagerUrl(final String mdStoreManagerUrl) {
		this.mdStoreManagerUrl = mdStoreManagerUrl;
	}

}
