package eu.dnetlib;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

/**
 * Created by claudio on 30/11/2016.
 */
@RestController
public class EndpointDocController {

	private static final Log log = LogFactory.getLog(EndpointDocController.class);

	@Autowired
	private List<RequestMappingHandlerMapping> handlerMappings;

	@RequestMapping(value = "/endpointdoc", method = RequestMethod.GET)
	public Set<String> show() {

		final Set<String> res = Sets.newHashSet();
		for(RequestMappingHandlerMapping handler : handlerMappings) {

			for(Entry<RequestMappingInfo, HandlerMethod> e : handler.getHandlerMethods().entrySet()) {
				final RequestMappingInfo info = e.getKey();
				res.add(info.toString());
			}
		}
		return res;
	}

}
