/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.researchfi;

import eu.dnetlib.data.collector.plugins.utils.JsonUtils;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;

public class ResearchFiIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(ResearchFiIterator.class);
    private static final int PAGE_SIZE = 100;
    private final String baseUrl;
    private final String authToken;
    private String nextUrl;
    private int nCalls = 0;
    private final Queue<String> queue = new PriorityBlockingQueue<String>();

    public ResearchFiIterator(String baseUrl, String authToken) {
        this.baseUrl = baseUrl;
        this.authToken = authToken;
        this.nextUrl = null;
    }

    private void verifyStarted() {
        try {
            if (this.nCalls == 0) {
                this.nextUrl = this.invokeUrl(this.baseUrl);
            }
        }
        catch (CollectorServiceException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            String res = this.queue.poll();
            while (this.queue.isEmpty() && StringUtils.isNotBlank((CharSequence)this.nextUrl)) {
                try {
                    this.nextUrl = this.invokeUrl(this.nextUrl);
                }
                catch (CollectorServiceException e) {
                    throw new IllegalStateException(e);
                }
            }
            return res;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String invokeUrl(String url) throws CollectorServiceException {
        ++this.nCalls;
        String next = null;
        log.info((Object)("Calling url: " + url));
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpGet req = new HttpGet(url);
            req.addHeader("Authorization", "Bearer " + this.authToken);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)req);){
                for (Header header : response.getAllHeaders()) {
                    log.debug((Object)("HEADER: " + header.getName() + " = " + header.getValue()));
                    if (!header.getName().equals("link")) continue;
                    String s = StringUtils.substringBetween((String)header.getValue(), (String)"<", (String)">");
                    String token = StringUtils.substringBefore((String)StringUtils.substringAfter((String)s, (String)"NextPageToken="), (String)"&");
                    next = this.baseUrl.contains("?") ? this.baseUrl + "&NextPageToken=" + token : this.baseUrl + "?NextPageToken=" + token;
                }
                String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                JSONArray jsonArray = new JSONArray(content);
                JsonUtils jsonUtils = new JsonUtils();
                jsonArray.forEach(obj -> this.queue.add(jsonUtils.convertToXML(obj.toString())));
            }
            String string = next;
            return string;
        }
        catch (Throwable e) {
            log.warn((Object)("Error calling url: " + url), e);
            throw new CollectorServiceException("Error calling url: " + url, e);
        }
    }
}

