/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.researchfi;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.plugins.researchfi.ResearchFiIterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class ResearchFiCollectorPlugin
extends AbstractCollectorPlugin {
    private static final Log log = LogFactory.getLog(ResearchFiCollectorPlugin.class);

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String authUrl = (String)interfaceDescriptor.getParams().get("auth_url");
        String clientId = (String)interfaceDescriptor.getParams().get("auth_client_id");
        String clientSecret = (String)interfaceDescriptor.getParams().get("auth_client_secret");
        String authToken = this.authenticate(authUrl, clientId, clientSecret);
        return () -> new ResearchFiIterator(interfaceDescriptor.getBaseUrl(), authToken);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String authenticate(String authUrl, String clientId, String clientSecret) throws CollectorServiceException {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost req = new HttpPost(authUrl);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("grant_type", "client_credentials"));
            params.add(new BasicNameValuePair("client_id", clientId));
            params.add(new BasicNameValuePair("client_secret", clientSecret));
            req.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)req);){
                String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                JSONObject obj = new JSONObject(content);
                String token = obj.getString("access_token");
                if (!StringUtils.isNotBlank((CharSequence)token)) throw new CollectorServiceException("Access token is missing");
                String string = token;
                return string;
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error obtaining access token", e);
            throw new CollectorServiceException("Error obtaining access token", e);
        }
    }
}

