/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.gtr2;

import eu.dnetlib.data.collector.plugins.gtr2.AbstractGtr2CollectorPlugin;
import eu.dnetlib.data.collector.plugins.gtr2.Gtr2Iterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Gtr2ProjectsCollectorPlugin
extends AbstractGtr2CollectorPlugin {
    @Override
    protected Iterator<String> createIterator(String baseUrl, String fromDate, String startPage, String endPage) throws CollectorServiceException {
        return new Gtr2Iterator(baseUrl, fromDate, startPage, endPage){

            @Override
            protected String urlForPage(String baseUrl, int pageNumber) {
                return baseUrl + "/projects?p=" + pageNumber;
            }

            @Override
            protected String xpathForEntity() {
                return "//*[local-name() = 'project']";
            }

            @Override
            protected String expandMainEntity(Element mainEntity) {
                Element newRoot = DocumentHelper.createElement((String)"doc");
                newRoot.add(mainEntity);
                this.addLinkedEntities(mainEntity, "LEAD_ORG", newRoot, o -> this.asOrgElement("ld-org", (Document)o));
                this.addLinkedEntities(mainEntity, "PP_ORG", newRoot, o -> this.asOrgElement("pp-org", (Document)o));
                this.addLinkedEntities(mainEntity, "PI_PER", newRoot, o -> this.asPersonElement("pi-per", (Document)o));
                this.addLinkedEntities(mainEntity, "FUND", newRoot, o -> this.asFundElement("funding", (Document)o));
                return DocumentHelper.createDocument((Element)newRoot).asXML();
            }

            private Element asOrgElement(String nodeName, Document doc) {
                Element newOrg = DocumentHelper.createElement((String)nodeName);
                newOrg.addElement("id").setText(doc.valueOf("/*/@*[local-name()='id']"));
                newOrg.addElement("name").setText(doc.valueOf("//*[local-name()='name']"));
                newOrg.addElement("country").setText(doc.valueOf("//*[local-name()='country']"));
                return newOrg;
            }

            private Element asPersonElement(String nodeName, Document doc) {
                Element newPers = DocumentHelper.createElement((String)nodeName);
                newPers.addElement("id").setText(doc.valueOf("/*/@*[local-name()='id']"));
                newPers.addElement("firstName").setText(doc.valueOf("//*[local-name()='firstName']"));
                newPers.addElement("otherNames").setText(doc.valueOf("//*[local-name()='otherNames']"));
                newPers.addElement("surname").setText(doc.valueOf("//*[local-name()='surname']"));
                return newPers;
            }

            private Element asFundElement(String nodeName, Document doc) {
                Element newFund = DocumentHelper.createElement((String)nodeName);
                newFund.addElement("id").setText(doc.valueOf("/*/@*[local-name()='id']"));
                newFund.addElement("start").setText(doc.valueOf("//*[local-name()='start']"));
                newFund.addElement("end").setText(doc.valueOf("//*[local-name()='end']"));
                newFund.addElement("valuePoundsAmount").setText(doc.valueOf("//*[local-name()='valuePounds']/@*[local-name()='amount']"));
                newFund.addElement("valuePoundsCurrencyCode").setText(doc.valueOf("//*[local-name()='valuePounds']/@*[local-name()='currencyCode']"));
                newFund.addElement("category").setText(doc.valueOf("//*[local-name()='category']"));
                return newFund;
            }
        };
    }
}

