/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.excel;

import eu.dnetlib.data.collector.plugins.HttpCSVCollectorPlugin;
import eu.dnetlib.data.collector.plugins.excel.CSVFileWriter;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;

public class Read {
    private static final Log log = LogFactory.getLog(Read.class);
    private InterfaceDescriptor descriptor;
    private Sheet sheet;
    private CSVFileWriter csv_writer = new CSVFileWriter();
    private HashMap<String, String> map_header = new HashMap();
    private HashMap<String, String> map_body = new HashMap();
    private int header_row;
    private String file_to_save;
    private boolean replace_currency = false;
    private String from_currency;
    private String to_currency;
    private boolean remove_empty;
    private boolean remove_tmp_file;
    private String remove_id;
    private int column_id;
    private int currency_column;
    private int sheet_number;
    private String tmp_file;
    private String argument;
    private String identifier;
    private HttpCSVCollectorPlugin collector;

    public HttpCSVCollectorPlugin getCollector() {
        return this.collector;
    }

    public void setCollector(HttpCSVCollectorPlugin collector) {
        this.collector = collector;
    }

    public Read(InterfaceDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    private static String getCellValue(Cell cell) {
        DataFormatter formatter = new DataFormatter();
        String formattedCellValue = formatter.formatCellValue(cell);
        return formattedCellValue;
    }

    private void copyFile() throws IOException {
        FileUtils.copyURLToFile((URL)new URL(this.descriptor.getBaseUrl()), (File)new File(this.tmp_file));
    }

    private void parseDescriptor() {
        HashMap params = this.descriptor.getParams();
        this.argument = (String)params.get("argument");
        this.header_row = Integer.parseInt((String)params.get("header_row"));
        this.tmp_file = (String)params.get("tmp_file");
        this.remove_empty = params.get("remove_empty_lines") == "yes";
        this.remove_id = (String)params.get("remove_lines_with_id");
        this.column_id = Integer.parseInt((String)params.get("col_id"));
        this.remove_tmp_file = params.get("remove_tmp_file") == "yes";
        this.sheet_number = Integer.parseInt((String)params.get("sheet_number"));
        this.file_to_save = (String)params.get("file_to_save");
    }

    private void init() throws IOException {
        this.parseDescriptor();
        log.info((Object)"Parsing the arguments");
        this.parseArguments();
        log.info((Object)"Copying the file in temp local file");
        this.copyFile();
        log.info((Object)("Extracting the sheet " + this.sheet_number));
        FileInputStream fis = new FileInputStream(this.tmp_file);
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);
        this.sheet = workbook.getSheetAt(this.sheet_number);
        fis.close();
        if (this.remove_tmp_file) {
            File f = new File(this.tmp_file);
            f.delete();
        }
    }

    private void fillMap(JSONObject json, HashMap<String, String> map, String elem) {
        try {
            JSONArray arr = json.getJSONObject("replace").getJSONArray(elem);
            for (Object entry : arr) {
                map.put(((JSONObject)entry).getString("from"), ((JSONObject)entry).getString("to"));
            }
        }
        catch (Throwable e) {
            log.error((Object)("Problems filling the map for " + elem));
            throw e;
        }
    }

    private void parseArguments() {
        if (StringUtils.isNotEmpty((CharSequence)this.argument)) {
            try {
                JSONObject json = new JSONObject(this.argument);
                JSONObject tmp = json.getJSONObject("replace");
                if (tmp.has("header")) {
                    this.fillMap(json, this.map_header, "header");
                }
                if (tmp.has("body")) {
                    this.fillMap(json, this.map_body, "body");
                }
                if (json.has("replace_currency")) {
                    this.replace_currency = true;
                    this.from_currency = json.getJSONArray("replace_currency").getJSONObject(0).getString("from");
                    this.to_currency = json.getJSONArray("replace_currency").getJSONObject(0).getString("to");
                }
                if (json.has("col_currency")) {
                    this.currency_column = json.getInt("col_currency");
                }
            }
            catch (Throwable e) {
                log.error((Object)"Problems while parsing the argument parameter.");
                throw e;
            }
        }
    }

    private String applyReplace(String row, HashMap<String, String> replace) {
        for (String key : replace.keySet()) {
            if (!row.contains(key)) continue;
            row = row.replace(key, replace.get(key));
        }
        return row;
    }

    private void getHeader() {
        Row row = this.sheet.getRow(this.header_row);
        Iterator cellIterator = row.cellIterator();
        String project = "";
        int count = 0;
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            String stringCellValue = cell.getStringCellValue();
            project = project + this.applyReplace(stringCellValue, this.map_header) + ";";
            if (count++ != this.column_id) continue;
            this.identifier = this.applyReplace(stringCellValue, this.map_header);
        }
        project = project.substring(0, project.length() - 1);
        this.csv_writer.setHeader(project.split(";"));
    }

    private void getData() {
        for (int row_number = this.header_row + 1; row_number < this.sheet.getLastRowNum(); ++row_number) {
            Row row = this.sheet.getRow(row_number);
            if (row == null) continue;
            Iterator cellIterator = row.cellIterator();
            int col_number = 0;
            boolean discard_row = false;
            ArrayList<String> al = new ArrayList<String>();
            while (cellIterator.hasNext() && !discard_row) {
                Cell cell = (Cell)cellIterator.next();
                String tmp = Read.getCellValue(cell).trim();
                tmp = tmp.replace("\n", " ");
                if (col_number == this.column_id && (this.remove_empty && tmp.trim().equals("") || !this.remove_id.equals("") && tmp.equals(this.remove_id))) {
                    discard_row = true;
                }
                if (this.replace_currency && col_number == this.currency_column) {
                    tmp = tmp.replace(this.from_currency, this.to_currency);
                }
                al.add(this.applyReplace(tmp, this.map_body));
                ++col_number;
            }
            if (discard_row) continue;
            this.csv_writer.addProject(al);
        }
    }

    private void writeCSVFile() {
        this.csv_writer.writeFile(this.file_to_save);
    }

    private InterfaceDescriptor prepareHTTPCSVDescriptor() {
        InterfaceDescriptor dex = new InterfaceDescriptor();
        dex.setBaseUrl("file://" + this.file_to_save);
        HashMap params = new HashMap();
        params.put("separator", this.descriptor.getParams().get("separator"));
        params.put("identifier", this.identifier);
        params.put("quote", this.descriptor.getParams().get("quote"));
        dex.setParams(params);
        return dex;
    }

    public Iterable<String> parseFile() throws Exception {
        this.init();
        log.info((Object)"Getting header elements");
        this.getHeader();
        log.info((Object)"Getting sheet data");
        this.getData();
        log.info((Object)"Writing the csv file");
        this.writeCSVFile();
        log.info((Object)"Preparing to parse csv");
        return this.collector.collect(this.prepareHTTPCSVDescriptor(), "", "");
    }
}

