/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.doiresolver;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.plugins.doiresolver.CrossrefResolver;
import eu.dnetlib.data.collector.plugins.doiresolver.DOIResolverIterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public class DOIResolverPlugin
extends AbstractCollectorPlugin
implements CollectorPlugin {
    private CrossrefResolver crossrefResolver;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String baseUrl = interfaceDescriptor.getBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorServiceException("Invalid date (YYYY-MM-DD): " + fromDate);
        }
        return () -> new DOIResolverIterator(interfaceDescriptor.getBaseUrl(), this.crossrefResolver, fromDate);
    }

    public CrossrefResolver getCrossrefResolver() {
        return this.crossrefResolver;
    }

    public void setCrossrefResolver(CrossrefResolver crossrefResolver) {
        this.crossrefResolver = crossrefResolver;
    }
}

