package eu.dnetlib.data.collector.plugins.gtr2;

import java.util.Iterator;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public abstract class AbstractGtr2CollectorPlugin extends AbstractCollectorPlugin {

	@Override
	public final Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
		throws CollectorServiceException {

		if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) { throw new CollectorServiceException("Invalid date (YYYY-MM-DD): " + fromDate); }

		final String baseUrl = interfaceDescriptor.getBaseUrl();
		final String startPage = interfaceDescriptor.getParams().get("startPage");
		final String endPage = interfaceDescriptor.getParams().get("endPage");

		return () -> {
			try {
				return createIterator(baseUrl, fromDate, startPage, endPage);
			} catch (final CollectorServiceException e) {
				throw new RuntimeException(e);
			}
		};
	}

	protected abstract Iterator<String> createIterator(String baseUrl, final String fromDate, String startPage, String endPage)
		throws CollectorServiceException;

}
