/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api.controller;

import eu.dnetlib.dhp.schema.sx.api.model.v3.PageResultType;
import eu.dnetlib.dhp.schema.sx.api.model.v3.ScholixType;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixIdentifier;
import eu.dnetlib.scholexplorer.api.ScholixException;
import eu.dnetlib.scholexplorer.api.index.ScholixIndexManager;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3"})
@Tag(name="Links : Operation related to the Scholix Links")
public class ScholixControllerV3 {
    @Autowired
    ScholixIndexManager repository;

    @Timed(value="scholix_index_request_links", description="Time taken to return links on Version 3.0 of Scholix")
    @Operation(summary="Get Scholix Links")
    @GetMapping(value={"/Links"})
    public PageResultType links(@RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a target pid") String targetPid, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a target published in a Publisher named targetPublisher") String targetPublisher, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a target type (publication, dataset, software, other)") String targetType, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a source pid") String sourcePid, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a source published in a Publisher named sourcePublisher") String sourcePublisher, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix relationships having a source type (publication, dataset, software, other)") String sourceType, @RequestParam(required=false) @Parameter(in=ParameterIn.QUERY, description="Filter Scholix having a specific relationships ") String relation, @Parameter(in=ParameterIn.QUERY, description="Filter scholix Links after this date") @RequestParam(required=false) String from, @Parameter(in=ParameterIn.QUERY, description="Filter scholix Links until this date") @RequestParam(required=false) String to, @Parameter(in=ParameterIn.QUERY, description="set the size of the page, default is 10, max is 100") @RequestParam(required=false) Integer size, @Parameter(in=ParameterIn.QUERY, description="select page of result") Integer page) throws Exception {
        if (StringUtils.isEmpty((CharSequence)sourcePid) && StringUtils.isEmpty((CharSequence)targetPid) && StringUtils.isEmpty((CharSequence)sourcePublisher) && StringUtils.isEmpty((CharSequence)targetPublisher) && StringUtils.isEmpty((CharSequence)sourceType) && StringUtils.isEmpty((CharSequence)targetType)) {
            throw new ScholixException("The method requires one of the following parameters: sourcePid, targetPid, sourcePublisher, targetPublisher, targetType, sourceType");
        }
        try {
            long currentPage = page != null ? (long)page.intValue() : 0L;
            long pgSize = size != null && size > 0 && size < 100 ? (long)size.intValue() : 10L;
            Pair scholixResult = this.repository.linksFromPid(null, targetPid, null, targetPublisher, targetType, sourcePid, null, sourcePublisher, sourceType, relation, from, to, Long.valueOf(currentPage), Integer.valueOf((int)pgSize));
            PageResultType pageResult = new PageResultType();
            long tp = (Long)scholixResult.getLeft();
            pageResult.setTotalPages(Long.valueOf(tp / pgSize + 1L));
            pageResult.setTotalLinks(Long.valueOf(tp));
            pageResult.setResult(((List)scholixResult.getRight()).stream().map(s -> {
                String sourceDnetId = s.getSource().getDnetIdentifier();
                ScholixIdentifier sId = new ScholixIdentifier();
                sId.setIdentifier(sourceDnetId);
                sId.setSchema("openaireIdentifier");
                sId.setUrl("https://explore.openaire.eu/search/result?id=" + sourceDnetId.replace("50|", ""));
                s.getSource().getIdentifier().add(sId);
                String targetDnetId = s.getTarget().getDnetIdentifier();
                ScholixIdentifier tId = new ScholixIdentifier();
                tId.setIdentifier(targetDnetId);
                tId.setSchema("openaireIdentifier");
                s.getTarget().getIdentifier().add(tId);
                tId.setUrl("https://explore.openaire.eu/search/result?id=" + targetDnetId.replace("50|", ""));
                return s;
            }).map(ScholixType::fromScholix).collect(Collectors.toList()));
            pageResult.setCurrentPage(Long.valueOf(currentPage));
            return pageResult;
        }
        catch (Throwable e) {
            throw new ScholixException("Error on requesting url ", e);
        }
    }
}

