/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api;

import eu.dnetlib.scholexplorer.api.ScholexplorerApiApplication;
import eu.dnetlib.scholexplorer.api.ScholixAPIConstants;
import eu.dnetlib.scholexplorer.api.TaggedCounter;
import io.micrometer.core.aop.TimedAspect;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class ScholexplorerApiApplication {
    @Value(value="${server.public_url}")
    private String serverPublicUrl;
    @Value(value="${server.public_desc}")
    private String serverPublicDesc;
    protected static final License AGPL_3_LICENSE = new License().name("GNU Affero General Public License v3.0 or later").url("https://www.gnu.org/licenses/agpl-3.0.txt");
    private final double scale = 1.0E9;
    private final double[] histogramValues = new double[]{5000000.0, 1.0E7, 2.5E8, 5.0E8, 7.5E8, 1.0E9, 2.5E9, 5.0E9, 7.5E9, 1.0E10};

    @Bean
    public TimedAspect timedAspect(MeterRegistry meterRegistry) {
        1 mf = new /* Unavailable Anonymous Inner Class!! */;
        meterRegistry.config().meterFilter((MeterFilter)mf);
        return new TimedAspect(meterRegistry);
    }

    @Bean
    public TaggedCounter myCounter(MeterRegistry meterRegistry) {
        return new TaggedCounter(ScholixAPIConstants.SCHOLIX_MANAGER_COUNTER_NAME, "links", meterRegistry);
    }

    @Bean
    public GroupedOpenApi publicApiV1() {
        return GroupedOpenApi.builder().group("Scholexplorer API V1.0").pathsToMatch(new String[]{"/v1/**"}).build();
    }

    @Bean
    public GroupedOpenApi publicApiV2() {
        return GroupedOpenApi.builder().group("Scholexplorer API V2.0").pathsToMatch(new String[]{"/v2/**"}).build();
    }

    @Bean
    public GroupedOpenApi publicApiKPI() {
        return GroupedOpenApi.builder().group("Scholexplorer API V3.0").pathsToMatch(new String[]{"/v3/**"}).build();
    }

    @Bean
    public OpenAPI newSwaggerDocket() {
        ArrayList<Server> servers = new ArrayList<Server>();
        if (StringUtils.isNotBlank((CharSequence)this.serverPublicUrl)) {
            Server server = new Server();
            server.setUrl(this.serverPublicUrl);
            server.setDescription(this.serverPublicDesc);
            servers.add(server);
        }
        return new OpenAPI().servers(servers).info(this.getSwaggerInfo()).tags(new ArrayList());
    }

    private Info getSwaggerInfo() {
        return new Info().title(this.swaggerTitle()).description(this.swaggerDesc()).license(AGPL_3_LICENSE);
    }

    protected String swaggerTitle() {
        return "ScholeExplorer APIs";
    }

    protected String swaggerDesc() {
        return ScholixAPIConstants.API_DESCRIPTION;
    }

    public static void main(String[] args) {
        SpringApplication.run(ScholexplorerApiApplication.class, (String[])args);
    }
}

