/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api.index;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import eu.dnetlib.scholexplorer.api.index.ElasticSearchProperties;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;

public class ElasticSearchClientFactory
implements PooledObjectFactory<ElasticsearchClient> {
    private final ElasticSearchProperties elasticSearchProperties;

    public ElasticSearchClientFactory(ElasticSearchProperties elasticSearchProperties) {
        this.elasticSearchProperties = elasticSearchProperties;
    }

    public PooledObject<ElasticsearchClient> makeObject() throws Exception {
        RestClient client = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)this.elasticSearchProperties.getClusterNodes())}).build();
        RestClientTransport transport = new RestClientTransport(client, (JsonpMapper)new JacksonJsonpMapper());
        ElasticsearchClient esClient = new ElasticsearchClient((ElasticsearchTransport)transport);
        return new DefaultPooledObject((Object)esClient);
    }

    public void destroyObject(PooledObject<ElasticsearchClient> pooledObject) throws Exception {
        ElasticsearchClient client = (ElasticsearchClient)pooledObject.getObject();
        if (client != null && client.ping().value()) {
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean validateObject(PooledObject<ElasticsearchClient> pooledObject) {
        ElasticsearchClient client = (ElasticsearchClient)pooledObject.getObject();
        try {
            return client.ping().value();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void activateObject(PooledObject<ElasticsearchClient> pooledObject) throws Exception {
        ElasticsearchClient client = (ElasticsearchClient)pooledObject.getObject();
        boolean response = client.ping().value();
    }

    public void passivateObject(PooledObject<ElasticsearchClient> pooledObject) throws Exception {
    }
}

