/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api.controller;

import eu.dnetlib.dhp.schema.sx.api.model.v2.LinkProviderType;
import eu.dnetlib.scholexplorer.api.ScholixException;
import eu.dnetlib.scholexplorer.api.index.ScholixIndexManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/LinkPublisher"})
@Tag(name="LinkPublisher : Operation related to the Link Publisher")
public class LinkPublisherV2 {
    @Autowired
    ScholixIndexManager manager;

    @Operation(summary="Get All Publishers that provide source object", description="Return a List of all Publishers that provide source objects in Scholix links and the total number of links where the source object comes from this publisher")
    @GetMapping(value={"/inSource"})
    public List<LinkProviderType> getInSource(@Parameter(in=ParameterIn.QUERY, description="Filter the link publisher name") @RequestParam(required=false) String name) throws ScholixException {
        ArrayList<LinkProviderType> result = new ArrayList<LinkProviderType>();
        this.manager.getLinkSourcePublishers().forEach((k, v) -> {
            if (name != null && k.toLowerCase().contains(name.toLowerCase())) {
                result.add(new LinkProviderType().name(k).totalRelationships(Integer.valueOf(v.intValue())));
            } else {
                result.add(new LinkProviderType().name(k).totalRelationships(Integer.valueOf(v.intValue())));
            }
        });
        return result;
    }

    @Operation(summary="Get All Publishers that provide target object", description="Return a List of all Publishers that provide source objects in Scholix links and the total number of links where the target object comes from this publisher")
    @GetMapping(value={"/inTarget"})
    public List<LinkProviderType> getInTarget(@Parameter(in=ParameterIn.QUERY, description="Filter the link publisher name") @RequestParam(required=false) String name) throws ScholixException {
        ArrayList<LinkProviderType> result = new ArrayList<LinkProviderType>();
        this.manager.getLinkTargetPublishers().forEach((k, v) -> {
            if (name != null && k.toLowerCase().contains(name.toLowerCase())) {
                result.add(new LinkProviderType().name(k).totalRelationships(Integer.valueOf(v.intValue())));
            } else {
                result.add(new LinkProviderType().name(k).totalRelationships(Integer.valueOf(v.intValue())));
            }
        });
        return result;
    }
}

