/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.solr;

import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import eu.dnetlib.dhp.solr.CloudClientParams;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.StreamSupport;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCloudSolrClient
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CacheCloudSolrClient.class);
    private static final CacheLoader<CloudClientParams, CloudSolrClient> loader = new CacheLoader<CloudClientParams, CloudSolrClient>(){

        public CloudSolrClient load(CloudClientParams params) throws Exception {
            return CacheCloudSolrClient.getCloudSolrClient(params);
        }
    };
    private static final RemovalListener<CloudClientParams, CloudSolrClient> listener = rn -> Optional.ofNullable((CloudSolrClient)rn.getValue()).ifPresent(client -> {
        try {
            client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    private static final LoadingCache<CloudClientParams, CloudSolrClient> cache = CacheBuilder.newBuilder().removalListener(listener).build(loader);

    public static void invalidateCachedClient(CloudClientParams params) {
        cache.invalidate((Object)params);
    }

    public static CloudSolrClient getCachedCloudClient(CloudClientParams params) throws ExecutionException {
        return (CloudSolrClient)cache.get((Object)params);
    }

    private static CloudSolrClient getCloudSolrClient(CloudClientParams cloudClientParams) {
        Integer socketTimeout;
        if (cloudClientParams == null) {
            throw new IllegalArgumentException("CloudClientParams cannot be null");
        }
        if (cloudClientParams.getZkHost() == null || cloudClientParams.getZkHost().isEmpty()) {
            throw new IllegalArgumentException("Zookeeper host cannot be null or empty");
        }
        if (cloudClientParams.getCollection() == null || cloudClientParams.getCollection().isEmpty()) {
            throw new IllegalArgumentException("Collection name cannot be null or empty");
        }
        log.debug("Creating a new SolrCloudClient for zkhost {}", (Object)cloudClientParams.getZkHost());
        String zkHost = cloudClientParams.getZkHost();
        log.info("Creating a new SolrCloudClient for zkhost {}", (Object)zkHost);
        List zkUrlList = StreamSupport.stream(Splitter.on((String)",").split((CharSequence)zkHost).spliterator(), false).toList();
        BasicHttpParams httpParams = new BasicHttpParams();
        Integer connectionTimeout = cloudClientParams.getZkConnectTimeout();
        if (connectionTimeout != null) {
            httpParams.setIntParameter("http.connection.timeout", connectionTimeout.intValue());
        }
        if ((socketTimeout = Integer.valueOf(cloudClientParams.getHttpSocketTimeoutMillis())) != null) {
            httpParams.setIntParameter("http.socket.timeout", socketTimeout.intValue());
        }
        PoolingClientConnectionManager connManager = new PoolingClientConnectionManager();
        connManager.setMaxTotal(cloudClientParams.getMaxConnTotal());
        connManager.setDefaultMaxPerRoute(cloudClientParams.getMaxConnPerRoute());
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connManager, (HttpParams)new DefaultedHttpParams((HttpParams)httpParams, null));
        CloudSolrClient solrClient = new CloudSolrClient.Builder(zkUrlList, Optional.empty()).withParallelUpdates(true).withLBHttpSolrClientBuilder((LBHttpSolrClient.Builder)((LBHttpSolrClient.Builder)((LBHttpSolrClient.Builder)new LBHttpSolrClient.Builder().withHttpClient((HttpClient)httpClient)).withConnectionTimeout(cloudClientParams.getHttpConnectTimeoutMillis())).withSocketTimeout(cloudClientParams.getHttpSocketTimeoutMillis())).build();
        solrClient.connect();
        log.debug("Created new SolrCloudClient for zkhost {}", (Object)zkHost);
        return solrClient;
    }
}

