package eu.dnetlib.dhp.solr.mapping;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import org.apache.solr.common.SolrInputDocument;
import org.apache.spark.sql.Row;

import java.io.Serializable;

public class RowToSolrInputDocumentMapper implements Serializable {

    private static final ObjectMapper mapper = new ObjectMapper();

    public static SolrInputDocument map(Row row, boolean shouldFilterXmlPayload) throws JsonProcessingException {

        String xml = row.getAs("xml");
        String json = row.getAs("json");

        final SolrRecord sr = mapper.readValue(json, SolrRecord.class);

        return SolrInputDocumentMapper.map(sr, xml, shouldFilterXmlPayload);
    }

    public static SolrInputDocument map(Row row) throws JsonProcessingException {

        return map(row, false);
    }


}
