/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.sword.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.app.directindex.sword.model.SwordIdDescProperty;
import eu.dnetlib.app.directindex.sword.model.SwordService;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SwordServiceDocument {
    private static final SwordIdDescProperty DEFAULT_COLLECTION_POLICY = new SwordIdDescProperty("http://TODO", "Collection Policy Of ....");
    private static final SwordIdDescProperty DEFAULT_TREATMENT = new SwordIdDescProperty("http://TODO", "Traeatment Of ....");
    @JsonProperty(value="@context")
    public final String context = "https://swordapp.github.io/swordv3/swordv3.jsonld";
    @JsonProperty(value="@id")
    public String id;
    @JsonProperty(value="@type")
    public final String type = "ServiceDocument";
    @JsonProperty(value="dc:title")
    public String title;
    @JsonProperty(value="dcterms:abstract")
    public String description;
    public String root;
    public final boolean acceptDeposits = true;
    public final String version = "http://purl.org/net/sword/3.0";
    public final long maxUploadSize = 0L;
    public final long maxByReferenceSize = 0L;
    public final long maxSegmentSize = 0L;
    public final long minSegmentSize = 0L;
    public final long maxAssembledSize = 0L;
    public final long maxSegments = 0L;
    public final List<String> accept = Arrays.asList("*/*");
    public final List<String> acceptArchiveFormat = Arrays.asList(new String[0]);
    public final List<String> acceptPackaging = Arrays.asList(new String[0]);
    public final List<String> acceptMetadata = Arrays.asList("OAF");
    public final SwordIdDescProperty collectionPolicy = DEFAULT_COLLECTION_POLICY;
    public final SwordIdDescProperty treatment = DEFAULT_TREATMENT;
    public final String staging;
    public final long stagingMaxIdle = 0L;
    public final boolean byReferenceDeposit = false;
    public final boolean onBehalfOf = false;
    public final List<String> digest = Arrays.asList("md5", "sha-256");
    public final List<String> authentication = Arrays.asList(new String[0]);
    public final List<SwordService> services = Arrays.asList(new SwordService[0]);

    public SwordServiceDocument() {
        this.staging = null;
    }

    public static SwordServiceDocument newInstance(String serviceDocId, String title, String desc) {
        SwordServiceDocument doc = new SwordServiceDocument();
        doc.setId(serviceDocId);
        doc.setRoot(serviceDocId);
        doc.setTitle(title);
        doc.setDescription(desc);
        return doc;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getContext() {
        return "https://swordapp.github.io/swordv3/swordv3.jsonld";
    }

    public String getType() {
        return "ServiceDocument";
    }

    public boolean isAcceptDeposits() {
        return true;
    }

    public String getVersion() {
        return "http://purl.org/net/sword/3.0";
    }

    public long getMaxUploadSize() {
        return 0L;
    }

    public long getMaxByReferenceSize() {
        return 0L;
    }

    public long getMaxSegmentSize() {
        return 0L;
    }

    public long getMinSegmentSize() {
        return 0L;
    }

    public long getMaxAssembledSize() {
        return 0L;
    }

    public long getMaxSegments() {
        return 0L;
    }

    public List<String> getAccept() {
        return this.accept;
    }

    public List<String> getAcceptArchiveFormat() {
        return this.acceptArchiveFormat;
    }

    public List<String> getAcceptPackaging() {
        return this.acceptPackaging;
    }

    public List<String> getAcceptMetadata() {
        return this.acceptMetadata;
    }

    public SwordIdDescProperty getCollectionPolicy() {
        return this.collectionPolicy;
    }

    public SwordIdDescProperty getTreatment() {
        return this.treatment;
    }

    public String getStaging() {
        return this.staging;
    }

    public long getStagingMaxIdle() {
        return 0L;
    }

    public boolean isByReferenceDeposit() {
        return false;
    }

    public boolean isOnBehalfOf() {
        return false;
    }

    public List<String> getDigest() {
        return this.digest;
    }

    public List<String> getAuthentication() {
        return this.authentication;
    }

    public List<SwordService> getServices() {
        return this.services;
    }
}

