/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.errors;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.app.directindex.errors.SwordErrorType;
import eu.dnetlib.app.directindex.errors.SwordException;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SwordError {
    @JsonProperty(value="@context")
    private final String context = "https://swordapp.github.io/swordv3/swordv3.jsonld";
    @JsonProperty(value="@type")
    private final SwordErrorType type;
    private final LocalDateTime timestamp;
    private final String error;
    private final String log;

    public SwordError(HttpServletRequest req, Throwable e) {
        this.type = e instanceof SwordException ? ((SwordException)e).getError() : SwordErrorType.BadRequest;
        this.error = e.getMessage();
        this.timestamp = LocalDateTime.now();
        this.log = ExceptionUtils.getStackTrace((Throwable)e);
    }

    public String getContext() {
        return "https://swordapp.github.io/swordv3/swordv3.jsonld";
    }

    public SwordErrorType getType() {
        return this.type;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getError() {
        return this.error;
    }

    public String getLog() {
        return this.log;
    }
}

