/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.app.directindex.errors.DirectIndexApiException;
import eu.dnetlib.app.directindex.errors.SwordError;
import eu.dnetlib.app.directindex.errors.SwordErrorType;
import eu.dnetlib.app.directindex.errors.SwordException;
import eu.dnetlib.app.directindex.input.ResultEntry;
import eu.dnetlib.app.directindex.mapping.SolrRecordMapper;
import eu.dnetlib.app.directindex.service.DirectIndexService;
import eu.dnetlib.app.directindex.solr.SolrIndexClient;
import eu.dnetlib.app.directindex.sword.model.SwordServiceDocument;
import eu.dnetlib.app.directindex.sword.model.SwordStatusDocument;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sword/3.0"})
@ConditionalOnProperty(value={"dnet.directindex.sword.enabled"}, havingValue="true")
public class SwordApiController {
    private static final String UNKNOWN_USER = "UNKNOWN";
    @Autowired
    private DirectIndexService service;
    @Autowired
    private SolrIndexClient solrIndexClient;
    @Autowired
    private SolrRecordMapper solRecordMapper;
    @Value(value="${dnet.directindex.baseurl}")
    private String baseUrl;
    @Value(value="${dnet.directindex.title}")
    private String title;
    @Value(value="${dnet.directindex.description}")
    private String description;

    @GetMapping(value={"/service-document"})
    public SwordServiceDocument getServiceDocument() {
        return SwordServiceDocument.newInstance((String)(this.baseUrl + "/api/sword/3.0/"), (String)this.title, (String)this.description);
    }

    @PostMapping(value={"/objects"})
    public ResponseEntity<SwordStatusDocument> addObject(@RequestHeader(value="Content-Type") String contentType, @RequestHeader(value="Content-Disposition") String contentDisposition, @RequestHeader(value="Digest") String digest, @RequestHeader(value="In-Progress", defaultValue="false") boolean inProgress, @RequestHeader(value="Metadata-Format", defaultValue="http://purl.org/net/sword/3.0/types/Metadata") String mdFormat, @RequestHeader(value="Packaging", defaultValue="http://purl.org/net/sword/3.0/package/Binary") String packaging, @RequestHeader(value="Slug") String slug, @RequestBody String json, Authentication authentication) throws SwordException {
        if (StringUtils.isNotBlank((CharSequence)digest)) {
            if (StringUtils.startsWith((CharSequence)digest, (CharSequence)"md5=")) {
                if (!DigestUtils.md5Hex((String)json).equals(StringUtils.substringAfter((String)digest, (String)"md5="))) {
                    throw new SwordException(SwordErrorType.DigestMismatch);
                }
            } else if (StringUtils.startsWith((CharSequence)digest, (CharSequence)"sha-256=")) {
                if (!DigestUtils.sha256Hex((String)json).equals(StringUtils.substringAfter((String)digest, (String)"sha-256="))) {
                    throw new SwordException(SwordErrorType.DigestMismatch);
                }
            } else {
                throw new SwordException(SwordErrorType.DigestMismatch);
            }
        }
        if (!"application/json".equals(contentType)) {
            throw new SwordException(SwordErrorType.ContentTypeNotAcceptable);
        }
        if (!"attachment; metadata=true".equals(contentDisposition) || inProgress) {
            throw new SwordException(SwordErrorType.MethodNotAllowed);
        }
        if (!"OAF".equals(mdFormat)) {
            throw new SwordException(SwordErrorType.MetadataFormatNotAcceptable);
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setLocation(null);
        try {
            String openaireId = this.service.prepareMetadataInsertOrUpdate(this.parseMetadata(json), (String)StringUtils.firstNonBlank((CharSequence[])new String[]{authentication.getName(), UNKNOWN_USER}));
            SwordStatusDocument status = SwordStatusDocument.newInstance((String)(this.baseUrl + "/api/sword/3.0"), (String)openaireId);
            return new ResponseEntity((Object)status, (MultiValueMap)responseHeaders, HttpStatus.ACCEPTED);
        }
        catch (JsonProcessingException | DirectIndexApiException e) {
            throw new SwordException(SwordErrorType.ContentMalformed);
        }
    }

    @GetMapping(value={"/objects/{id}/metadata"})
    public ResponseEntity<ResultEntry> getMetadata(@PathVariable String id, Authentication authentication) throws SwordException {
        try {
            SolrRecord metadata = this.solrIndexClient.findRecord(id);
            if (metadata == null) {
                throw new SwordException(SwordErrorType.NotFound);
            }
            return new ResponseEntity((Object)this.solRecordMapper.toResultEntry(metadata), HttpStatus.OK);
        }
        catch (DirectIndexApiException e) {
            throw new SwordException(SwordErrorType.ContentMalformed);
        }
    }

    @PutMapping(value={"/objects/{id}/metadata"})
    public ResponseEntity<Void> replaceMetadata(@RequestHeader(value="Content-Disposition") String contentDisposition, @RequestHeader(value="Content-Length") String contentLength, @RequestHeader(value="Content-Type") String contentType, @RequestHeader(value="Digest") String digest, @RequestHeader(value="Metadata-Format", defaultValue="http://purl.org/net/sword/3.0/types/Metadata") String mdFormat, @PathVariable String id, @RequestBody ResultEntry result, Authentication authentication) throws SwordException {
        try {
            if (!this.solrIndexClient.existsRecord(id)) {
                throw new SwordException(SwordErrorType.NotFound);
            }
            result.setOpenaireId(id);
            this.service.prepareMetadataInsertOrUpdate(result, (String)StringUtils.firstNonBlank((CharSequence[])new String[]{authentication.getName(), UNKNOWN_USER}));
            return new ResponseEntity(HttpStatus.ACCEPTED);
        }
        catch (DirectIndexApiException e) {
            throw new SwordException(SwordErrorType.ContentMalformed);
        }
    }

    @DeleteMapping(value={"/objects/{id}"})
    public ResponseEntity<Void> deleteObject(@PathVariable String id, Authentication authentication) {
        this.service.prepareMetadataDeletion(id, (String)StringUtils.firstNonBlank((CharSequence[])new String[]{authentication.getName(), UNKNOWN_USER}));
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    private ResultEntry parseMetadata(String json) throws JsonProcessingException, JsonMappingException {
        return (ResultEntry)new ObjectMapper().readValue(json, ResultEntry.class);
    }

    @ExceptionHandler(value={Throwable.class})
    public SwordError handleException(HttpServletRequest req, HttpServletResponse res, Throwable e) throws IOException {
        if (e instanceof SwordException) {
            res.setStatus(((SwordException)e).getError().getHttpCode());
        } else {
            res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        return new SwordError(req, e);
    }
}

