/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.clients;

import eu.dnetlib.app.directindex.clients.DatasourceManagerClient;
import eu.dnetlib.app.directindex.clients.HasCache;
import eu.dnetlib.app.directindex.errors.DirectIndexApiException;
import eu.dnetlib.app.directindex.input.DatasourceEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class DatasourceManagerClient
implements HasCache {
    @Value(value="${dnet.directindex.dsm.url}")
    private String dsmApiUrl;
    private static final Log log = LogFactory.getLog(DatasourceManagerClient.class);

    @Cacheable(value={"datasources"})
    public DatasourceEntry findDatasource(String dsId) throws DirectIndexApiException {
        if (StringUtils.isBlank((CharSequence)dsId)) {
            return DatasourceEntry.UNKNOWN_DATASOURCE;
        }
        RestTemplate rt = new RestTemplate();
        String url = this.dsmApiUrl + "/searchdetails/0/1?requestSortBy=id&order=ASCENDING";
        try {
            DsmSearchResponse res = (DsmSearchResponse)rt.postForObject(url, (Object)new DsmSearchRequest(dsId), DsmSearchResponse.class, new Object[0]);
            return res.getDatasourceInfo().stream().map(ds -> new DatasourceEntry(ds.getId(), ds.getOfficialname(), ds.getNamespaceprefix())).findFirst().orElse(DatasourceEntry.UNKNOWN_DATASOURCE);
        }
        catch (RestClientException rce) {
            log.warn((Object)("Unable to obtain datasource: " + dsId), (Throwable)rce);
            throw new DirectIndexApiException("Unable to obtainn datasource: " + dsId, (Throwable)rce);
        }
    }

    @CacheEvict(value={"datasources"}, allEntries=true)
    public void clearCache() {
    }

    public String getDsmApiUrl() {
        return this.dsmApiUrl;
    }

    public void setDsmApiUrl(String dsmApiUrl) {
        this.dsmApiUrl = dsmApiUrl;
    }
}

