/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex.clients;

import eu.dnetlib.app.directindex.clients.CommunityClient;
import eu.dnetlib.app.directindex.clients.HasCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class CommunityClient
implements HasCache {
    public static final String ZENODO_COMMUNITY = "zenodo.org/communities/";
    private static final Log log = LogFactory.getLog(CommunityClient.class);
    @Value(value="${dnet.directindex.community.url}")
    private String communityApiUrl;

    @Cacheable(value={"oa_community_lists"})
    public List<String> findOpenaireCommunities(String zenodoId) {
        if (StringUtils.isBlank((CharSequence)zenodoId)) {
            return new ArrayList<String>();
        }
        String url = this.communityApiUrl + "/" + zenodoId + "/openairecommunities";
        return ((ZenodoContextList)new RestTemplate().getForObject(url, ZenodoContextList.class, new Object[0])).getOpenAirecommunitylist();
    }

    @Cacheable(value={"contexts"})
    public Map<String, ContextInfo> findNodes(String path) {
        String root = path.split("::")[0];
        log.debug((Object)("Preparing context: " + root));
        HashMap<Object, ContextInfo> res = new HashMap<Object, ContextInfo>();
        RestTemplate rt = new RestTemplate();
        Community c = (Community)rt.getForObject(this.communityApiUrl + "/" + root, Community.class, new Object[0]);
        res.put(c.getId(), new ContextInfo((String)StringUtils.firstNonBlank((CharSequence[])new String[]{c.getDisplayName(), c.getName()}), c.getType()));
        for (SubCommunity sc : (SubCommunity[])rt.getForObject(this.communityApiUrl + "/" + root + "/subcommunities?all=true", SubCommunity[].class, new Object[0])) {
            String[] arr = sc.getSubCommunityId().split("::");
            if (arr.length <= 2) continue;
            res.put(arr[0] + "::" + arr[1], new ContextInfo(sc.getCategory(), ""));
            res.put(sc.getSubCommunityId(), new ContextInfo(sc.getLabel(), ""));
        }
        return res.entrySet().stream().filter(e -> path.equals(e.getKey()) || path.startsWith((String)e.getKey() + "::")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @CacheEvict(value={"contexts", "oa_community_lists"}, allEntries=true)
    public void clearCache() {
    }

    public String getCommunityApiUrl() {
        return this.communityApiUrl;
    }

    public void setCommunityApiUrl(String communityApiUrl) {
        this.communityApiUrl = communityApiUrl;
    }
}

