/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.app.directindex;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Metrics;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableCaching
@EnableScheduling
@SpringBootApplication(exclude={SolrAutoConfiguration.class})
public class DirectIndexApplication {
    private static final Logger log = LoggerFactory.getLogger(DirectIndexApplication.class);
    private static final String DIRECT_INDEX_DESC = "APIs documentation";
    private static final License AGPL_3_LICENSE = new License().name("GNU Affero General Public License v3.0 or later").url("https://www.gnu.org/licenses/agpl-3.0.txt");
    @Value(value="${maven.pom.path}")
    private ClassPathResource pom;
    @Value(value="${dnet.directindex.baseurl}")
    private String publicUrl;
    @Value(value="${dnet.directindex.title}")
    private String publicTitle;
    @Value(value="${dnet.directindex.description}")
    private String publicDesc;

    public static void main(String[] args) {
        SpringApplication.run(DirectIndexApplication.class, (String[])args);
    }

    @PostConstruct
    public void init() {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            Model model = reader.read((Reader)new InputStreamReader(this.pom.getInputStream()));
            log.info(String.format("registering metric for %s", model.getArtifactId()));
            ImmutableTag tag1 = new ImmutableTag("component", model.getGroupId() + ":" + model.getArtifactId());
            ImmutableTag tag2 = new ImmutableTag("version", model.getVersion());
            ImmutableTag tag3 = new ImmutableTag("scmtag", model.getScm().getTag());
            Metrics.gauge((String)"micrometer_info", Arrays.asList(tag1, tag2, tag3), (Number)1);
        }
        catch (IOException | XmlPullParserException e) {
            log.error("Error registering metric", e);
        }
    }

    @Bean
    public OpenAPI newSwaggerDocket() {
        ArrayList<Server> servers = new ArrayList<Server>();
        if (StringUtils.isNotBlank((CharSequence)this.publicUrl)) {
            Server server = new Server();
            server.setUrl(this.publicUrl);
            server.setDescription(this.publicDesc);
            servers.add(server);
        }
        return new OpenAPI().servers(servers).info(new Info().title(this.publicTitle).description(DIRECT_INDEX_DESC).version(this.currentVersion()).license(AGPL_3_LICENSE)).tags(new ArrayList());
    }

    private String currentVersion() {
        try {
            return new MavenXpp3Reader().read((Reader)new InputStreamReader(this.pom.getInputStream())).getVersion();
        }
        catch (IOException | XmlPullParserException e) {
            return "UNKNOWN";
        }
    }

    @Bean
    public GroupedOpenApi publicApi() {
        return GroupedOpenApi.builder().group(this.publicTitle).pathsToMatch(new String[]{"/api/**"}).build();
    }
}

