package eu.dnetlib.app.directindex.input;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema.RequiredMode;

public class ResultEntry implements Serializable {

	private static final long serialVersionUID = 3171122009783163319L;

	private String openaireId;
	private String originalId;

	@Schema(requiredMode = RequiredMode.REQUIRED)
	private String title;
	private List<String> authors = new ArrayList<>();
	private String publisher;
	private String description;

	@Schema(description = "ISO Alpha-3 code. E.g. 'eng', 'ita'")
	private String language;
	private List<PidEntry> pids = new ArrayList<>();

	@Schema(requiredMode = RequiredMode.REQUIRED, allowableValues = { "OPEN", "CLOSED", "RESTRICTED", "EMBARGO", "UNKNOWN", "OTHER", "OPEN SOURCE" })
	@JsonProperty("accessRightCode")
	@JsonAlias({ "licenseCode", "licenceCode" }) // DEPRECATED aliases
	private String accessRightCode;

	private String embargoEndDate;

	/**
	 * One of publication, dataset, software, other. Default value is publication.
	 */
	@Schema(allowableValues = { "publication", "dataset", "software", "other" })
	private String type = "publication";

	@Schema(requiredMode = RequiredMode.REQUIRED, description = "Use 0001 for articles, 0021 for datasets, 0029 for software. See: http://api.openaire.eu/vocabularies/dnet:publication_resource for all the available resource types.")
	private String resourceType;

	@Schema(requiredMode = RequiredMode.REQUIRED)
	private String url;

	@Schema(requiredMode = RequiredMode.REQUIRED, description = "Use opendoar___::2659 for Zenodo Publications; re3data_____::r3d100010468 for Zenodo datasets; infrastruct::openaire for OpenAIRE portal.")
	private String collectedFromId;

	private String hostedById;

	// String according to the EGI context profile, example: egi::classification::natsc::math

	@Schema(description = "E.g. fet, egi::classification::natsc::math::pure, egi::projects::EMI")
	private List<String> contexts = new ArrayList<>();

	// String according to openaire guidelines:
	// info:eu-repo/grantAgreement/Funder/FundingProgram/ProjectID/[Jurisdiction]/[ProjectName]/[ProjectAcronym]
	@Schema(description = "E.g. info:eu-repo/grantAgreement/EC/FP7/283595/EU//OpenAIREplus")
	private List<String> linksToProjects = new ArrayList<>();

	private static final Log log = LogFactory.getLog(ResultEntry.class);

	public ResultEntry() {}

	public String getOpenaireId() {
		return openaireId;
	}

	public void setOpenaireId(final String openaireId) {
		this.openaireId = openaireId;
	}

	public String getOriginalId() {
		return originalId;
	}

	public void setOriginalId(final String originalId) {
		this.originalId = originalId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	public List<String> getAuthors() {
		return authors;
	}

	public void setAuthors(final List<String> authors) {
		this.authors = authors;
	}

	public String getPublisher() {
		return publisher;
	}

	public void setPublisher(final String publisher) {
		this.publisher = publisher;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public String getLanguage() {
		return language;
	}

	public void setLanguage(final String language) {
		this.language = language;
	}

	public List<PidEntry> getPids() {
		return pids;
	}

	public void setPids(final List<PidEntry> pids) {
		this.pids = pids;
	}

	public String getAccessRightCode() {
		return accessRightCode;
	}

	public void setAccessRightCode(final String accessRightCode) {
		this.accessRightCode = accessRightCode;
	}

	public String getResourceType() {
		return resourceType;
	}

	public void setResourceType(final String resourceType) {
		this.resourceType = resourceType;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(final String url) {
		this.url = url;
	}

	public String getCollectedFromId() {
		return collectedFromId;
	}

	public void setCollectedFromId(final String collectedFromId) {
		this.collectedFromId = collectedFromId;
	}

	public String getHostedById() {
		return hostedById;
	}

	public void setHostedById(final String hostedById) {
		this.hostedById = hostedById;
	}

	public List<String> getContexts() {
		return contexts;
	}

	public void setContexts(final List<String> contexts) {
		this.contexts = contexts;
	}

	public List<String> getLinksToProjects() {
		return linksToProjects;
	}

	public void setLinksToProjects(final List<String> linksToProjects) {
		this.linksToProjects = linksToProjects;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getEmbargoEndDate() {
		return embargoEndDate;
	}

	public void setEmbargoEndDate(final String embargoEndDate) {
		this.embargoEndDate = embargoEndDate;
	}

	@Override
	public String toString() {
		return toJson();
	}

	public String toJson() {
		try {
			return new ObjectMapper().writeValueAsString(this);
		} catch (final JsonProcessingException e) {
			log.error("Error converting object in json", e);
			throw new RuntimeException("Error converting object in json", e);
		}
	}
}
