package eu.dnetlib.app.directindex.input;

import java.io.Serializable;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class DatasourceEntry implements Serializable {

	private static final long serialVersionUID = -8627323814467461993L;

	private String id;
	private String name;
	private String prefix;

	public static final DatasourceEntry UNKNOWN_DATASOURCE =
			new DatasourceEntry("openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18", "Unknown Repository", "unknown_____");

	public DatasourceEntry() {}

	public DatasourceEntry(final String id, final String name, final String prefix) {
		this.id = id;
		this.name = name;
		this.prefix = prefix;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(final String prefix) {
		this.prefix = prefix;
	}

	public String calculateOpenaireId() {
		if (StringUtils.isNotBlank(id)) {
			final String[] arr = id.split("::");
			if (arr.length == 2) { return String.format("%s::%s", arr[0], DigestUtils.md5Hex(arr[1])); }
		}
		return "";
	}
}
