package eu.dnetlib.broker.common.elasticsearch;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;

public interface SuggestionEventRepository extends ElasticsearchRepository<SuggestionEvent, String> {
	// TODO: use the @Query annotation if necessary
	// See: http://docs.spring.io/spring-data/elasticsearch/docs/current/reference/html/

	Iterable<SuggestionEvent> findByTopic(String topic);

	Page<SuggestionEvent> findByTopic(String topic, Pageable pageable);

	long deleteByExpiryDateBetween(long from, long to);

	long deleteByCreationDateBetween(long from, long to);

}
