/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.openaireAlerts;

import eu.dnetlib.broker.common.elasticsearch.AlertNotificationRepository;
import eu.dnetlib.broker.common.stats.OpenaireDsStat;
import eu.dnetlib.broker.common.stats.OpenaireDsStatRepository;
import eu.dnetlib.broker.common.subscriptions.ConditionOperator;
import eu.dnetlib.broker.common.subscriptions.ConditionParams;
import eu.dnetlib.broker.common.subscriptions.MapCondition;
import eu.dnetlib.broker.common.subscriptions.NotificationFrequency;
import eu.dnetlib.broker.common.subscriptions.NotificationMode;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.broker.common.utils.MapValueType;
import eu.dnetlib.broker.events.output.DispatcherManager;
import eu.dnetlib.broker.openaireAlerts.AlertSubscriptionDesc;
import eu.dnetlib.broker.openaireAlerts.DatasourceWithAlert;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class OpenaireAlertsService {
    private static final Log log = LogFactory.getLog(OpenaireAlertsService.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private OpenaireDsStatRepository dsStatRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private AlertNotificationRepository alertNotificationRepository;
    @Autowired
    private DispatcherManager dispatcher;

    @Transactional
    public OpenaireDsStat updateStats(OpenaireDsStat stats) {
        this.dsStatRepository.deleteAlertsByDsId(stats.getId());
        return (OpenaireDsStat)this.dsStatRepository.save((Object)stats);
    }

    public Optional<Subscription> findSubscription(String subscrId) {
        return this.subscriptionRepo.findById((Object)subscrId);
    }

    public String findDatasouceName(String dsId) {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{(String)this.jdbcTemplate.queryForObject("select name from oa_datasource_stats where id=? and topic ilike 'ALERT/%' limit 1", String.class, new Object[]{dsId}), dsId});
    }

    public List<DatasourceWithAlert> findDatasourcesWithAlerts() {
        try {
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sql/datasourceWithAlerts.sql"), (String)"UTF-8");
            RowMapper mapper = (rs, rowNum) -> new DatasourceWithAlert(rs.getString("id"), rs.getString("name"), rs.getString("rule"), rs.getLong("size"));
            return this.jdbcTemplate.query(sql, mapper);
        }
        catch (Exception e) {
            log.error((Object)"Error executing query", (Throwable)e);
            return new ArrayList<DatasourceWithAlert>();
        }
    }

    public List<AlertSubscriptionDesc> listAlertSubscriptions(String email) {
        Iterable iter = this.subscriptionRepo.findBySubscriber(email);
        return StreamSupport.stream(iter.spliterator(), false).filter(s -> s.getTopic().startsWith("ALERT/")).map(arg_0 -> this.subscriptionDesc(arg_0)).sorted(Comparator.comparing(AlertSubscriptionDesc::getDsName)).collect(Collectors.toList());
    }

    private AlertSubscriptionDesc subscriptionDesc(Subscription s) {
        String dsId = this.extractDatasourceId(s);
        String dsName = this.findDatasouceName(dsId);
        return new AlertSubscriptionDesc(s.getSubscriptionId(), dsId, dsName, s.getTopic(), s.getCreationDate(), s.getLastNotificationDate(), this.alertNotificationRepository.countBySubscriptionId(s.getSubscriptionId()));
    }

    public Subscription registerSubscription(String email, String dsId, String topic) {
        for (Subscription s : this.subscriptionRepo.findBySubscriber(email)) {
            if (!topic.equalsIgnoreCase(s.getTopic()) || !dsId.equalsIgnoreCase(this.extractDatasourceId(s))) continue;
            throw new IllegalArgumentException("Already subscribed");
        }
        String subscriptionId = "sub-" + UUID.randomUUID();
        ArrayList<MapCondition> conds = new ArrayList<MapCondition>();
        conds.add(new MapCondition("datasourceId", MapValueType.STRING, ConditionOperator.EXACT, Arrays.asList(new ConditionParams(dsId, null))));
        Subscription s = new Subscription(subscriptionId, email, topic, NotificationFrequency.realtime, NotificationMode.EMAIL, null, new Date(), conds);
        return (Subscription)this.subscriptionRepo.save((Object)s);
    }

    public void sendAlertNotifications(String dsId) {
        for (Subscription s : this.subscriptionRepo.findAll()) {
            if (!s.getTopic().startsWith("ALERT/") || !s.getConditionsAsList().stream().anyMatch(c -> "datasourcId".equals(c.getField()) && c.getListParams().stream().anyMatch(p -> dsId.equals(p.getValue())))) continue;
            long count = this.alertNotificationRepository.countBySubscriptionId(s.getSubscriptionId());
            if (count > 0L) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("oa_notifications_total", count);
                params.put("oa_datasource", this.extractDatasourceId(s));
                this.dispatcher.sendNotification(s, params);
            }
            s.setLastNotificationDate(new Date());
            this.subscriptionRepo.save((Object)s);
        }
    }

    private String extractDatasourceId(Subscription sub) {
        return sub.getConditionsAsList().stream().filter(c -> "datasourceId".equals(c.getField())).map(MapCondition::getListParams).filter(l -> !l.isEmpty()).map(l -> ((ConditionParams)l.get(0)).getValue()).findFirst().orElse("");
    }
}

