/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.utils;

import java.util.Date;

public class QueryGenerator {
    public static final String SelectFieldsPart = "SELECT c.id AS id, c.userMail as userMail, c.date as date, c.sourceType as sourceType, c.targetType as targetType, c.sourceId as sourceId, c.targetId as targetId, c.semantics as semantics, target.title as targetTitle, target.collectedFrom as targetCollectedFrom, sourceResult.title as sourceResultTitle, sourceProject.name as projectTitle, sourceProject.acronym as projectAcronym, sourceProject.funderName as projectFunderName, sourceProject.funderShortName as projectFunderShortName, sourceProject.funderId as projectFunderId, sourceContext.title as contextTitle, sourceOrganization.name as organizationTitle";
    public static final String BaseQuery = " FROM Claim c  JOIN Result target on  c.targetId = target.openaireId   LEFT OUTER JOIN Project sourceProject on  c.sourceId = sourceProject.openaireId  LEFT OUTER JOIN Result sourceResult on  c.sourceId = sourceResult.openaireId  LEFT OUTER JOIN Context sourceContext on  c.sourceId = sourceContext.openaireId  LEFT OUTER JOIN Organization sourceOrganization on  c.sourceId = sourceOrganization.openaireId  WHERE (c.targetType IN :targetTypes OR c.sourceType IN :sourceTypes) AND c.userMail LIKE CONCAT(:userMailPrefix, '%') ";
    private static final String SelectClaimFields = "c.id AS id, c.userMail as userMail, c.date as date, c.sourceType as sourceType, c.targetType as targetType, c.sourceId as sourceId, c.targetId as targetId, c.semantics as semantics";

    public static String getWhereClause(String keyword) {
        if (keyword.length() == 0) {
            return "";
        }
        String q = "AND (lower(target.title) LIKE CONCAT('%', :keyword , '%')  OR lower(sourceResult.title) LIKE CONCAT('%', :keyword , '%') OR lower(sourceProject.name) LIKE CONCAT('%', :keyword , '%') OR lower(sourceProject.acronym) LIKE CONCAT('%', :keyword , '%') OR lower(sourceProject.funderName) LIKE CONCAT('%', :keyword , '%') OR lower(sourceProject.funderShortName) LIKE CONCAT('%', :keyword , '%') OR lower(sourceContext.title) LIKE CONCAT('%', :keyword , '%') OR lower(c.userMail) LIKE CONCAT('%', :keyword , '%') OR lower(sourceOrganization.name) LIKE CONCAT('%', :keyword , '%'))";
        return q;
    }

    public static String getSourceClause(String type, String id) {
        if (type == null || id == null) {
            return "";
        }
        String q = "AND (c.sourceType = :sourceType  AND c.sourceId = :sourceId)";
        if (type == "context") {
            q = "AND (c.sourceType = :sourceType  AND c.sourceId LIKE CONCAT(:sourceId, '%') )";
        }
        return q;
    }

    public static String getDateClause(Date from, Date to) {
        if (from == null || to == null) {
            return "";
        }
        String q = "AND (c.date >= :dateFrom  AND c.date <= :dateTo)";
        return q;
    }

    public static String getOrderByClause(String sortBy, Boolean DESC) {
        Object orderBy = " ORDER BY ";
        switch (sortBy) {
            case "user": {
                orderBy = (String)orderBy + " c.userMail ";
                break;
            }
            case "title": {
                orderBy = (String)orderBy + " target.title ";
                break;
            }
            default: {
                orderBy = (String)orderBy + " c.date ";
            }
        }
        return (String)orderBy + (DESC != false ? " DESC " : " ASC ");
    }

    public static String getPagingClause(Integer offset, Integer first) {
        return " offset " + offset + " rows fetch first " + first + " rows only";
    }
}

