/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.service;

import com.google.gson.Gson;
import eu.dnetlib.claims.model.ManagerInfo;
import eu.dnetlib.claims.service.BasicFetchService;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ManagerUtilsService
extends BasicFetchService {
    @Value(value="${services.claims.registryAPIForManagerEmails}")
    private String registryAPIForManagerEmails;
    private static final Logger log = LogManager.getLogger(ManagerUtilsService.class);

    @PostConstruct
    public void checkProperties() {
        log.debug("Try to get managers for covid-19... ");
        List managers = this.getManagersByEmail("covid-19");
        if (managers != null) {
            log.debug("Found " + this.getManagersByEmail("covid-19").size());
        } else {
            log.warn("Couldn't load managers list..");
        }
    }

    public List<ManagerInfo> getManagersByEmail(String community) {
        String url = this.registryAPIForManagerEmails.replace("{community}", community);
        log.info("Registry url is " + url);
        try {
            String responseStr = this.getRequest(url);
            return this.json2ManagerUtils(responseStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<ManagerInfo> json2ManagerUtils(String json) {
        if (json == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new StringReader(json));
        Gson gson = new Gson();
        List<ManagerInfo> managerUtilsList = null;
        try {
            ManagerInfo[] testCase = (ManagerInfo[])gson.fromJson((Reader)br, ManagerInfo[].class);
            managerUtilsList = Arrays.asList(testCase);
        }
        catch (Throwable e) {
            log.debug("Error in parsing json response. Given json is : " + json, e);
            e.printStackTrace();
            return null;
        }
        return managerUtilsList;
    }

    public Boolean isCommunityManager(String communityId, String userMail) {
        List managerUtils = this.getManagersByEmail(communityId);
        if (managerUtils != null) {
            for (ManagerInfo manager : managerUtils) {
                if (manager.getEmail() == null || !manager.getEmail().equals(userMail)) continue;
                return true;
            }
        }
        return false;
    }
}

