/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.service;

import com.google.gson.Gson;
import eu.dnetlib.claims.model.Concept;
import eu.dnetlib.claims.model.Context;
import eu.dnetlib.claims.service.BasicFetchService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FetchContextService
extends BasicFetchService {
    @Value(value="${services.claims.contextsAPIUrl}")
    private String APIURL;

    public Context fetchContextById(String openaireId) {
        Context context = new Context();
        if (openaireId == null) {
            return null;
        }
        context.setOpenaireId(openaireId);
        try {
            context.setTitle(this.extractLabel(context.getOpenaireId()));
        }
        catch (Exception e) {
            this.logger.error("ContextUtils: Couldn't get Egi label for id " + context.getOpenaireId(), (Throwable)e);
        }
        return context;
    }

    private String fetchContext(String suffix) throws Exception {
        return this.getRequest(this.APIURL + suffix);
    }

    private String extractLabel(String code) throws Exception {
        String json;
        String[] codeParts = code.split("::");
        String level0 = "";
        String level1 = "";
        String level2 = "";
        String level3 = "";
        if (codeParts.length > 0) {
            json = this.fetchContext("s/");
            level0 = this.getLabel(json, codeParts[0]);
        }
        if (codeParts.length > 1) {
            json = this.fetchContext("/" + codeParts[0]);
            level1 = this.getLabel(json, codeParts[0] + "::" + codeParts[1]);
        }
        if (codeParts.length > 2) {
            json = this.fetchContext("/category/" + codeParts[0] + "::" + codeParts[1]);
            level2 = this.getLabel(json, codeParts[0] + "::" + codeParts[1] + "::" + codeParts[2]);
        }
        if (codeParts.length > 3) {
            json = this.fetchContext("/category/concept/" + codeParts[0] + "::" + codeParts[1] + "::" + codeParts[2]);
            level3 = this.getSubLabel(json, codeParts[0] + "::" + codeParts[1] + "::" + codeParts[2], codeParts[0] + "::" + codeParts[1] + "::" + codeParts[2] + "::" + codeParts[3], codeParts.length > 4 ? codeParts[0] + "::" + codeParts[1] + "::" + codeParts[2] + "::" + codeParts[3] + "::" + codeParts[4] : null);
        }
        return level0 + (String)(level1.length() > 0 ? "> " + level1 + (String)(level3.length() > 0 ? "> " + level3 : (level2.length() > 0 ? "> " + level2 : "")) : "");
    }

    private String getLabel(String json, String id) {
        if (json == null) {
            return null;
        }
        Gson gson = new Gson();
        Concept[] concepts = (Concept[])gson.fromJson(json, Concept[].class);
        if (concepts != null && concepts.length > 0) {
            for (int i = 0; i < concepts.length; ++i) {
                Concept concept = concepts[i];
                if (concept.getType() != null && concept.getType().equals("funding") || !concept.getId().equals(id)) continue;
                return concept.getLabel();
            }
        }
        return "";
    }

    private String getSubLabel(String json, String id, String subId, String subsubId) {
        if (json == null) {
            return null;
        }
        Gson gson = new Gson();
        Concept[] concepts = (Concept[])gson.fromJson(json, Concept[].class);
        if (concepts != null && concepts.length > 0) {
            block0: for (int i = 0; i < concepts.length; ++i) {
                Concept concept = concepts[i];
                if (concept.getType() != null && concept.getType().equals("funding") || !concept.getId().equals(id) || concept.getConcepts() == null) continue;
                for (int j = 0; j < concept.getConcepts().size(); ++j) {
                    Concept subConcept = (Concept)concept.getConcepts().get(j);
                    if (!subConcept.getId().equals(subId)) continue;
                    if (subsubId == null || subConcept.getConcepts() == null) {
                        return subConcept.getLabel();
                    }
                    for (int k = 0; k < subConcept.getConcepts().size(); ++k) {
                        Concept subSubConcept = (Concept)subConcept.getConcepts().get(k);
                        if (!subSubConcept.getId().equals(subsubId)) continue;
                        return subSubConcept.getLabel();
                    }
                    continue block0;
                }
            }
        } else {
            return null;
        }
        return "";
    }
}

