/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.service;

import eu.dnetlib.claims.model.Result;
import eu.dnetlib.claims.parser.ExternalRecordParser;
import eu.dnetlib.claims.service.BasicFetchService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FetchFromOrcidService
extends BasicFetchService {
    @Value(value="${services.claims.orcidUrlPrefix}")
    private String APIURL;
    @Value(value="${services.claims.orcidUrlSuffix}")
    private String aPIUrlSuffix;

    private String fetchOrcidRecord(String id) throws Exception {
        return this.fetchResultXMLFromOrcid(id);
    }

    public Result fetchResultfromOrcid(String id, String idSuffix) throws Exception {
        Result result = ExternalRecordParser.orcid2Result((String)this.fetchOrcidRecord(id), (String)id, (String)idSuffix);
        return result;
    }

    private String fetchResultXMLFromOrcid(String id) throws Exception {
        return this.getRequest(this.APIURL + id.substring(0, 19) + this.aPIUrlSuffix + id.substring(20));
    }

    public String getAPIURL() {
        return this.APIURL;
    }

    public String getAPIUrlSuffix() {
        return this.aPIUrlSuffix;
    }

    public void setAPIURL(String APIURL) {
        this.APIURL = APIURL;
    }

    public void setAPIUrlSuffix(String aPIUrlSuffix) {
        this.aPIUrlSuffix = aPIUrlSuffix;
    }
}

