/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.service;

import eu.dnetlib.claims.model.Organization;
import eu.dnetlib.claims.model.Project;
import eu.dnetlib.claims.model.Result;
import eu.dnetlib.claims.parser.OpenAIRERecordParser;
import eu.dnetlib.claims.service.BasicFetchService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FetchFromGraphService
extends BasicFetchService {
    @Value(value="${services.claims.searchAPIUrl}")
    private String APIURL;
    OpenAIRERecordParser openAIRERecordParser = new OpenAIRERecordParser();

    FetchFromGraphService() {
    }

    public Result fetchResultById(String id, String type) throws Exception {
        String json = null;
        Object requestUrl = this.APIURL;
        requestUrl = type.equals("software") ? (String)requestUrl + "software/" + id : (type.equals("dataset") ? (String)requestUrl + "datasets/" + id : (type.equals("other") ? (String)requestUrl + "other/" + id : (String)requestUrl + "publications/" + id));
        json = this.getRequest((String)(requestUrl = (String)requestUrl + "?format=json"));
        if (json == null) {
            requestUrl = this.APIURL + "datasets/" + id + "?format=json";
            json = this.getRequest((String)requestUrl);
        }
        if (json == null) {
            return null;
        }
        return this.openAIRERecordParser.parse2Result(json);
    }

    public Project fetchProjectById(String id) throws Exception {
        String json = this.getRequest(this.APIURL + "projects/" + id + "?format=json");
        System.out.println(json);
        if (json == null) {
            return null;
        }
        return this.openAIRERecordParser.parse2Project(json);
    }

    public Organization fetchOrganizationById(String id) throws Exception {
        String json = this.getRequest(this.APIURL + "organizations/" + id + "?format=json");
        System.out.println(json);
        if (json == null) {
            return null;
        }
        return this.openAIRERecordParser.parse2Organization(json);
    }
}

