/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.claims.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.claims.model.Organization;
import eu.dnetlib.claims.model.Project;
import eu.dnetlib.claims.model.Result;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenAIRERecordParser {
    private static final Logger logger = LogManager.getLogger(OpenAIRERecordParser.class);

    public Result parse2Result(String json) {
        if (json == null) {
            return null;
        }
        try {
            JsonNode pids;
            Result result = new Result();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode root = objectMapper.readTree(json);
            if (root.has("header")) {
                result.setOpenaireId(root.get("header").get("id").asText());
                result.setResultType(root.get("header").get("recordType").asText());
            }
            if (root.has("result")) {
                result.setAccessRights(root.get("result").has("bestaccessright") && root.get("result").get("bestaccessright").has("code") ? root.get("result").get("bestaccessright").get("code").asText() : null);
                if (result.getAccessRights() != null && result.getAccessRights().equals("EMBARGO") && root.get("result").has("embargoenddate")) {
                    result.setEmbargoEndDate(root.get("result").get("embargoenddate").asText());
                }
                result.setTitle(root.get("result").has("maintitle") ? root.get("result").get("maintitle").asText() : null);
            }
            if (root.has("pid") && (pids = root.get("pid")).isArray()) {
                for (JsonNode pidNode : pids) {
                    if (!pidNode.has("typeCode") || !pidNode.get("typeCode").asText().equals("doi") || result.getDoi() != null) continue;
                    result.setDoi(pidNode.get("value").asText());
                    result.setExternalUrl("http://dx.doi.org/" + result.getDoi());
                    break;
                }
            }
            if (result.getExternalUrl() == null && root.has("instance")) {
                JsonNode instanceNodes = root.get("instance");
                Optional<JsonNode> openInstance = StreamSupport.stream(instanceNodes.spliterator(), false).filter(instanceNode -> instanceNode.has("accessright") && instanceNode.has("url") && (instanceNode.get("accessright").get("value").asText().equals("Open Access") || instanceNode.get("accessright").get("value").asText().equals("OPEN"))).findFirst();
                if (openInstance.isPresent()) {
                    result.setExternalUrl(openInstance.get().get("url").asText());
                } else {
                    Optional<JsonNode> embargoInstance = StreamSupport.stream(instanceNodes.spliterator(), false).filter(instanceNode -> instanceNode.has("accessright") && instanceNode.has("url") && (instanceNode.get("accessright").get("value").asText().equals("Embargo") || instanceNode.get("accessright").get("value").asText().equals("EMBARGO"))).findFirst();
                    if (embargoInstance.isPresent()) {
                        result.setExternalUrl(embargoInstance.get().get("url").asText());
                    } else {
                        Optional<JsonNode> closedInstance = StreamSupport.stream(instanceNodes.spliterator(), false).filter(instanceNode -> instanceNode.has("accessright") && instanceNode.has("url") && (instanceNode.get("accessright").get("value").asText().equals("Closed Access") || instanceNode.get("accessright").get("value").asText().equals("CLOSED"))).findFirst();
                        if (embargoInstance.isPresent()) {
                            result.setExternalUrl(closedInstance.get().get("url").asText());
                        } else {
                            Optional<JsonNode> anyInstance = StreamSupport.stream(instanceNodes.spliterator(), false).filter(instanceNode -> instanceNode.has("url")).findFirst();
                            if (anyInstance.isPresent()) {
                                result.setExternalUrl(closedInstance.get().get("url").asText());
                            }
                        }
                    }
                }
            }
            result.setCollectedFrom("infrastruct_::openaire");
            result.setRecordFormat("json");
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Project parse2Project(String json) {
        if (json == null) {
            return null;
        }
        try {
            Project project = new Project();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode root = objectMapper.readTree(json);
            if (root.has("header")) {
                project.setOpenaireId(root.get("header").get("id").asText());
            }
            if (root.has("project")) {
                project.setName(root.get("project").has("title") ? root.get("project").get("title").asText() : null);
                project.setAcronym(root.get("project").has("acronym") ? root.get("project").get("acronym").asText() : null);
                if (root.get("project").has("funding") && root.get("project").get("funding").has("funder")) {
                    project.setFunderId(root.get("project").get("funding").get("funder").has("id") ? root.get("project").get("funding").get("funder").get("id").asText() : null);
                    project.setFunderName(root.get("project").get("funding").get("funder").has("name") ? root.get("project").get("funding").get("funder").get("name").asText() : null);
                    project.setFunderShortName(root.get("project").get("funding").get("funder").has("shortname") ? root.get("project").get("funding").get("funder").get("shortname").asText() : project.getFunderId().split("::")[0]);
                }
            }
            return project;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Organization parse2Organization(String json) {
        if (json == null) {
            return null;
        }
        try {
            JsonNode pids;
            Organization organization = new Organization();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode root = objectMapper.readTree(json);
            if (root.has("header")) {
                Iterator iterator;
                JsonNode originalIdNodes;
                organization.setOpenaireId(root.get("header").get("id").asText());
                if (root.get("header").has("originalId") && (originalIdNodes = root.get("header").get("originalId")).isArray() && (iterator = originalIdNodes.iterator()).hasNext()) {
                    JsonNode originalId = (JsonNode)iterator.next();
                    organization.setOriginalId(originalId.asText());
                }
            }
            if (root.has("pid") && (pids = root.get("pid")).isArray()) {
                for (JsonNode pidNode : pids) {
                    if (pidNode.has("typeCode") && pidNode.get("typeCode").asText().equals("ROR") && organization.getRORId() == null) {
                        organization.setRORId(pidNode.get("value").asText());
                        continue;
                    }
                    if (!pidNode.has("typeCode") || !pidNode.get("typeCode").asText().equals("GRID") || organization.getGRIDId() != null) continue;
                    organization.setGRIDId(pidNode.get("value").asText());
                }
            }
            if (root.has("organization")) {
                organization.setName(root.get("organization").has("legalname") ? root.get("organization").get("legalname").asText() : null);
                organization.setShortName(root.get("organization").has("legalshortname") ? root.get("organization").get("legalshortname").asText() : null);
                organization.setUrl(root.get("organization").has("websiteurl") ? root.get("organization").get("websiteurl").asText() : null);
                organization.setCountry(root.get("organization").has("country") && root.get("organization").get("country").has("code") ? root.get("organization").get("country").get("code").asText() : null);
            }
            return organization;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String createOpenaireId(String id) {
        if (id == null) {
            return null;
        }
        Object openaireId = id;
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("MD5");
            m.update(id.getBytes(), 0, id.length());
            openaireId = new BigInteger(1, m.digest()).toString(16);
            while (((String)openaireId).length() < 32) {
                openaireId = "0" + (String)openaireId;
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Couldn't instatiate md5 algorithm", (Throwable)e);
        }
        openaireId = "userclaim___::" + (String)openaireId;
        return openaireId;
    }
}

