package eu.dnetlib.validator.service.impls.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import eu.dnetlib.validator.commons.dao.jobs.JobsDAO;
import eu.dnetlib.validator.commons.email.Emailer;
import eu.dnetlib.validator.engine.execution.CompletedTask;
import eu.dnetlib.validator.engine.execution.JobListener;

public class CompatibilityTestListener implements JobListener{
	private static Logger logger = Logger.getLogger(CompatibilityTestListener.class);
	
	private Emailer emailer = null;
	private String valBaseUrl = null;
	private String validationSet = null; 
	private String guidelines = null;
	private JobsDAO jobsDao;
	
	private int totalJobs;
	private int jobsFinished = 0;

	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public synchronized void finished(int jobId, Map<String, Object> jobContext) {
		try {
			jobsFinished++;
			if (jobsFinished == totalJobs) {
				logger.debug("all jobs finished");
				jobsDao.setTotalJobFinished(jobId, null, false);
				this.sendMail((Integer) jobContext.get("jobSubmittedId"), (String) jobContext.get("jobSubmittedUser"));
			} else {
				logger.debug("not all jobs finished yet. Waiting "+ (totalJobs-jobsFinished) + " job(s) to finish" );
			}
		} catch (Exception e) {
			logger.error("Error while finalizing successfull compatibility test job", e);
		}
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public synchronized void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
		try {
			jobsFinished++;
			if (jobsFinished == totalJobs) {
				jobsDao.setTotalJobFinished(jobId, t.getMessage(), true);
				this.sendMail((Integer) jobContext.get("jobSubmittedId"), (String) jobContext.get("jobSubmittedUser"));
			} else {
				logger.debug("not all jobs finished yet. Waiting "+ (totalJobs-jobsFinished) + " job(s) to finish" );
			}
		} catch (Exception e) {
			logger.error("Error while finalizing failed compatibility test job", e);
		}
	}


	
	private void sendMail(int jobSubmittedId, String jobSubmittedUser) {
		logger.debug("JOBID:"+jobSubmittedId+"# Sending email for finished job");
		String mailTo = jobSubmittedUser;
		List<String> recipients = new ArrayList<String>();
		recipients.add(mailTo);
		String msgUpgrade = "";
//		if (this.validationSet != null && !this.validationSet.equalsIgnoreCase("openaire"))
		if (this.guidelines.equalsIgnoreCase("openaire2.0") || this.guidelines.equalsIgnoreCase("driver"))
			msgUpgrade = "\n\n Please consider to upgrade to OpenAIRE Guidelines v3. Link: https://guidelines.openaire.eu/wiki/OpenAIRE_Guidelines:_For_Literature_repositories";
		String message = "The compatibility test you have submitted has finished. You can retrieve the results by following this url: " + valBaseUrl + "/prepareSummary.action?jobId=" + jobSubmittedId  + msgUpgrade;

		String subject = "OpenAIRE compatibility Test Results";
		try {
				emailer.sendMail(recipients, subject, message, false, null);
		} catch (Exception e) {
			logger.error("JOBID:"+jobSubmittedId+"# Error sending email for finished job", e);
		}
	}
	
	@Override
	public void currentResults(List<CompletedTask> tasks, int jobId,
			Object object, Map<String, Object> recordContext, Throwable t) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void currentResults(List<CompletedTask> tasks, int jobId,
			Object object, Map<String, Object> recordContext) {
		// TODO Auto-generated method stub
		
	}

	public String getValBaseUrl() {
		return valBaseUrl;
	}

	public void setValBaseUrl(String valBaseUrl) {
		this.valBaseUrl = valBaseUrl;
	}

	public String getValidationSet() {
		return validationSet;
	}

	public void setValidationSet(String validationSet) {
		this.validationSet = validationSet;
	}

	public Emailer getEmailer() {
		return emailer;
	}

	public void setEmailer(Emailer emailer) {
		this.emailer = emailer;
	}

	public String getGuidelines() {
		return guidelines;
	}

	public void setGuidelines(String guidelines) {
		this.guidelines = guidelines;
	}

	public int getTotalJobs() {
		return totalJobs;
	}

	public void setTotalJobs(int totalJobs) {
		this.totalJobs = totalJobs;
	}

	public JobsDAO getJobsDao() {
		return jobsDao;
	}

	public void setJobsDao(JobsDAO jobsDao) {
		this.jobsDao = jobsDao;
	}

	
}
