<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                                xmlns="http://namespace.openaire.eu/sygma">
    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

    <xsl:template match = "/">
        <response>
            <xsl:apply-templates select="response/header"/>
            <publications>
                <xsl:apply-templates select="//result"/>
            </publications>
        </response>
    </xsl:template>

    <xsl:template match="response/header">
        <header>
            <size><xsl:value-of select="size"/></size>
            <page><xsl:value-of select="page"/></page>
            <total><xsl:value-of select="total"/></total>
        </header>
    </xsl:template>

    <xsl:template match="field[@name='pid']/field[@name='classid' and @value='doi']" name="idnode">
    </xsl:template>

    <xsl:template match="result">
        <publication>
            <openaireid><xsl:value-of select="field[@name='resultId']/@value"/></openaireid>
            <doi>
                <xsl:for-each select="field[@name='pid']">
                    <xsl:if test="field[@name='classid' and @value='doi']/@value = 'doi'">
                        <xsl:value-of select="field[@name='value']/@value"/>
                    </xsl:if>
                </xsl:for-each>
            </doi>
            <description><xsl:value-of select="field[@name='description']/@value"/></description>
            <publicationtype><xsl:value-of select="field[@name='datasource'][1]/field[@name='typename']/@value"/></publicationtype>
            <title><xsl:value-of select="field[@name='title']/@value"/></title>
            <authors>
                <xsl:for-each select="field[@name='hasAuthor']">
                    <author><xsl:value-of select="field[@name='fullname']/@value"/></author>
                </xsl:for-each>
            </authors>
            <xsl:for-each select="field[@name='source']">
                <sourcejournal><xsl:value-of select="@value"/></sourcejournal>
            </xsl:for-each>
            <dateofacceptance><xsl:value-of select="field[@name='dateofacceptance']/@value"/></dateofacceptance>
            <xsl:for-each select="field[@name='datasource']">
                <xsl:for-each select="field[@name='url']">
                    <webresource><xsl:value-of select="@value"/></webresource>
                </xsl:for-each>
            </xsl:for-each>
            <bestlicense><xsl:value-of select="field[@name='bestlicense']/@value"/></bestlicense>
        </publication>
    </xsl:template>

</xsl:stylesheet>