<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:opensearch="http://a9.com/-/spec/opensearch/1.1/">
    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

    <xsl:template match = "/">
        <rss version="2.0">
            <channel>
                <xsl:apply-templates select="response/header"/>
                <xsl:apply-templates select="//result"/>
            </channel>
        </rss>
    </xsl:template>

    <xsl:template match="response/header">
        <title>OpenAIRE search results</title>
        <link>www.openaire.eu</link>
        <description><xsl:value-of select="concat('Results for query: ', query)"/></description>
        <language><xsl:value-of select="locale"/></language>
        <pubDate><xsl:value-of  select="current-dateTime()"/></pubDate>
        <lastBuildDate><xsl:value-of  select="current-dateTime()"/></lastBuildDate>
        <generator>OpenAIRE RSS Generator</generator>

        <opensearch:totalResults><xsl:value-of select="total"/></opensearch:totalResults>
        <opensearch:startIndex><xsl:value-of select="page"/></opensearch:startIndex>
        <opensearch:itemsPerPage><xsl:value-of select="size"/></opensearch:itemsPerPage>
    </xsl:template>

    <xsl:template match="result">
        <item>
            <title><xsl:value-of select="field[@name='title']/@value"/></title>
            <description><xsl:value-of select="field[@name='description']/@value"/></description>
            <xsl:for-each select="field[@name='hasAuthor']">
                <author><xsl:value-of select="field[@name='fullname']/@value"/></author>
            </xsl:for-each>
            <xsl:for-each select="field[@name='datasource']">
                <xsl:for-each select="field[@name='url']">
                    <link><xsl:value-of select="@value"/></link>
                </xsl:for-each>
            </xsl:for-each>
            <pubDate><xsl:value-of select="field[@name='dateofacceptance']/@value"/></pubDate>
        </item>
    </xsl:template>

</xsl:stylesheet>


