<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dri="http://www.driver-repository.eu/namespace/dri"
xmlns:oaf="http://namespace.openaire.eu/oaf"
xmlns:dc="http://purl.org/dc/elements/1.1/">
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>

<xsl:template match = "/">
<result type ="result">
	<xsl:apply-templates select="//header"/>
	<xsl:apply-templates select="//oaf:project"/>
</result>
</xsl:template>

<xsl:template match = "header">
	<field name="encoding" multiplicity="false" indexId="objIdentifier" label="Object id">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:objIdentifier'/>
		</xsl:attribute>
	</field>
</xsl:template>



<xsl:template match = "oaf:project">
	<xsl:choose>
		<xsl:when test="./acronym != '' and ./acronym != 'UNKNOWN'">
			<field name="value" multiplicity="true" indexId="relprojectid" label="Project name">
				<xsl:attribute name="value">
                    <xsl:value-of select="./acronym"/>
                </xsl:attribute>
			</field>
		</xsl:when>
		<xsl:otherwise>
				<field name="value" multiplicity="true" indexId="relprojectid" label="Project name">
                    <xsl:attribute name="value">
                           <xsl:value-of select="./title"/>
                    </xsl:attribute>
				</field>
		</xsl:otherwise>
	</xsl:choose>				
</xsl:template>

</xsl:stylesheet>


