<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dri="http://www.driver-repository.eu/namespace/dri"
xmlns:oaf="http://namespace.openaire.eu/oaf"
xmlns:dc="http://purl.org/dc/elements/1.1/">
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>
<!-- PROJECT
missing fields:
1. scientific area ?
2. programme ?
3. cordis link ?
4. publications
 -->
<xsl:template match = "/">
<result type ="result">
	<xsl:apply-templates select="//header"/>
	<xsl:apply-templates select="//oaf:project"/>
	<xsl:apply-templates select="//rel"/>
	<!--xsl:apply-templates select="//funding[parent[not(node())]] "/-->
	<xsl:apply-templates select="//funding_level_2"/>
	<xsl:apply-templates select="//funding_level_1"/>
	<xsl:apply-templates select="//funding_level_0"/>
</result>
</xsl:template>

<!-- HEADER
fields in header:
1. dri:objIdentifier 		[objIdentifier]
2. dri:repositoryId			X
3. dri:dateOfCollection		X
-->
<xsl:template match = "header">
	<field name="projectId" multiplicity="false" indexId="objIdentifier" label="Object id">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:objIdentifier'/>
		</xsl:attribute>
	</field>
	<xsl:if test="substring(./dri:objIdentifier,1,4)='ec::'">
		<field name="grantagreementnumber" multiplicity="false" indexId="" label="Grant agreement number">
			<xsl:attribute name="value">
				<xsl:value-of select="substring(./dri:objIdentifier,5)"/>
			</xsl:attribute>
		</field>
	</xsl:if>
	
	<!--<field name="repositoryId" multiplicity="false" indexId="???" label="???">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:repositoryId'/>
		</xsl:attribute>
	</field>-->
	<!--<field name="dateOfCollection" multiplicity="false" indexId="???" label="???">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:dateOfCollection'/>
		</xsl:attribute>
	</field>-->
</xsl:template>

<xsl:template match = "oaf:project">

	<xsl:for-each select = "./acronym">
		<field name="name" indexId = "projectacronym" multiplicity="true" label="Project">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	
	<xsl:for-each select = "./code">
		<field name="code" indexId = "projectcode" multiplicity="true" label="Project code">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./title">
		<field name="title" indexId = "projecttitle" multiplicity="true" label="Title">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./startdate">
		<field name="startyear" indexId = "projectstartyear" multiplicity="true" label="Start year">
			<xsl:attribute name="value">
				<xsl:value-of select='substring-before(.,"-")'/>
			</xsl:attribute>
		</field>
		<field name="startdate" indexId = "projectstartdate" multiplicity="true" label="Start date">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./enddate">
		<field name="endyear" indexId = "projectendyear" multiplicity="true" label="End year">
			<xsl:attribute name="value">
				<xsl:value-of select="substring-before(.,'-')"/>
			</xsl:attribute>
		</field>
		<field name="enddate" indexId = "projectenddate" multiplicity="true" label="End date">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./callidentifier">
		<field name="call_identifier" indexId = "projectcallidentifier" multiplicity="true" label="Call">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./ecsc39">
		<field name="ec_sc39" indexId = "projectecsc39" multiplicity="true" label="Special clause 39"> 
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./collectedfrom">
		<field name="collectedfrom" indexId = "projectcollectedfrom" multiplicity="true" label="Collected from">
                        <xsl:attribute name="value">
                                <xsl:value-of select='./@id'/>
                        </xsl:attribute>
                </field>
                <field name="collectedfromname" indexId = "" multiplicity="true" label="Collected from name">
                        <xsl:attribute name="value">
                                <xsl:value-of select='./@name'/>
                        </xsl:attribute>
                </field>
	</xsl:for-each>


	<xsl:for-each select = "./contracttype">
		<field name="contracttypeid" indexId = "projectcontracttypeid" multiplicity="true" label="Contract type id"> 
			<xsl:attribute name="value">
				<xsl:value-of select='./@classid'/>
			</xsl:attribute>
		</field>
		<field name="contracttypename" indexId = "projectcontracttypename" multiplicity="true" label="Contract type name"> 
			<xsl:attribute name="value">
				<xsl:value-of select='./@classname'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./pid">
		<field name="pidid" indexId = "pidclassid" multiplicity="true" label="Pid">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classid'/>
			</xsl:attribute>
		</field>
		<field name="pidname" indexId = "pidclassname" multiplicity="true" label="Pid">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classname'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./websiteurl">
		<field name="websiteurl" indexId = "projectwebsiteurl" multiplicity="true" label="Website url"> 
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./keywords">
		<field name="keywords" indexId = "projectkeywords" multiplicity="true" label="Keywords"> 
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./duration">
		<field name="duration" indexId = "projectduration" multiplicity="true" label="Duration"> 
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

</xsl:template>


<!--  RELS  
1. person 
2. project	
3. organisation 
4. result  
5. datasource 
-->
<xsl:template match="rel">
<!--PERSON-->
	<xsl:if test="./to/@type='person'">
		<field name="author" indexId = "objIdentifier"  multiplicity="true">
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "personId" indexId ="objIdentifier" multiplicity="false" label="Person id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "role" indexId ="" multiplicity="false" label="role">		
				<xsl:attribute name="value"><xsl:value-of select='./to/@class'/> </xsl:attribute>
			</field>
			<field name = "fullname" indexId ="personfullname" multiplicity="false" label="Person fullname">		
				<xsl:attribute name="value"><xsl:value-of select='./fullname'/> </xsl:attribute>
			</field>
			<field name = "ranking" indexId ="" multiplicity="false" label="ranking">		
				<xsl:attribute name="value"><xsl:value-of select='./ranking'/> </xsl:attribute>
			</field>
		</field>
	</xsl:if>
<!--PROJECT-->
	<xsl:if test="./to/@type='project'">
		<field name="project" indexId = "objIdentifier" multiplicity="true">
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "projectId" indexId ="objIdentifier" multiplicity="false" label="Project id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "role" indexId ="" multiplicity="false" label="role">		
				<xsl:attribute name="value"><xsl:value-of select='./to/@class'/> </xsl:attribute>
			</field>
			<field name = "projectcode" indexId ="projectcode" multiplicity="false" label="Project(s)">		
				<xsl:attribute name="value"><xsl:value-of select='./code'/> </xsl:attribute>
			</field>	
			<field name = "projectacronym" indexId ="projectacronym" multiplicity="false" label="Project(s)">		
				<xsl:attribute name="value"><xsl:value-of select='./acronym'/> </xsl:attribute>
			</field>
			<field name = "projecttitle" indexId ="projecttitle" multiplicity="false" label="Project title">		
				<xsl:attribute name="value"><xsl:value-of select='./title'/> </xsl:attribute>
			</field>
			<field name = "projectcontracttypeid" indexId ="projectcontracttypeid" multiplicity="false" label="Project contract type id">		
				<xsl:attribute name="value"><xsl:value-of select='./contracttype/@classid'/> </xsl:attribute>
			</field>
			<field name = "projectcontracttypename" indexId ="projectcontracttypename" multiplicity="false" label="Project contract type name">		
				<xsl:attribute name="value"><xsl:value-of select='./contracttype/@classname'/> </xsl:attribute>
			</field>
		</field>
	</xsl:if>
<!--RESULT-->
	<xsl:if test="./to/@type='result'">
		<field name="result" indexId = "objIdentifier"  multiplicity="true">
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "resultid" indexId ="objIdentifier" multiplicity="false" label="Result id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "title" indexId = "resulttitle" multiplicity = "false" label = "Title">
				<xsl:attribute name="value">
					<xsl:value-of select="./title"/>
				</xsl:attribute>
			</field>
			<field name = "dateofacceptance" indexId = "resultdateofacceptance" multiplicity = "false" label = "Date of acceptance">
				<xsl:attribute name="value">
					<xsl:value-of select="./dateofacceptance"/>
				</xsl:attribute>
			</field>
			<field name = "resulttypeid" indexId = "resulttypeid" multiplicity = "false" label = "type id">
				<xsl:attribute name="value">
					<xsl:value-of select="./resulttype/@classid"/>
				</xsl:attribute>
			</field>
			<field name = "resulttypename" indexId = "resulttypename" multiplicity = "false" label = "type name">
				<xsl:attribute name="value">
					<xsl:value-of select="./resulttype/@classname"/>
				</xsl:attribute>
			</field>
		</field>
	</xsl:if>	
<!--ORGANIZATION-->
	<xsl:if test="./to/@type='organization'">
		<field name="organization" indexId = "objIdentifier"  multiplicity="true">
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "organizationid" indexId ="objIdentifier" multiplicity="false" label="Organization id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "role" indexId ="" multiplicity="false" label="role">		
				<xsl:attribute name="value"><xsl:value-of select='./to/@class'/> </xsl:attribute>
			</field>
			<field name = "legalshortname" indexId ="organizationlegalshortname" multiplicity="false" label="Organization short name">		
				<xsl:attribute name="value"><xsl:value-of select='./legalshortname'/> </xsl:attribute>
			</field>
			<field name = "legalname" indexId ="organizationlegalname" multiplicity="false" label="Organization name">		
				<xsl:attribute name="value"><xsl:value-of select='./legalname'/> </xsl:attribute>
			</field>
			<field name = "websiteurl" indexId ="organizationwebsiteurl" multiplicity="false" label="Website">		
				<xsl:attribute name="value"><xsl:value-of select='./websiteurl'/> </xsl:attribute>
			</field>
			<field name = "countryid" indexId ="organizationcountryid" multiplicity="false" label="Country code">		
				<xsl:attribute name="value"><xsl:value-of select='./country/@classid'/> </xsl:attribute>
			</field>
			<field name = "countryname" indexId ="organizationcountryname" multiplicity="false" label="Country">		
				<xsl:attribute name="value"><xsl:value-of select='./country/@classname'/> </xsl:attribute>
			</field>
			<field name = "participantnumber" indexId ="" multiplicity="false" label="Participant Number">		
				<xsl:attribute name="value"><xsl:value-of select='./participantnumber'/> </xsl:attribute>
			</field>
			<field name = "contactperson" indexId ="" multiplicity="false" label="Contact Person">		
				<xsl:attribute name="value"><xsl:value-of select='./contactperson'/> </xsl:attribute>
			</field>
		</field>
	</xsl:if>

</xsl:template>

<xsl:template match="funding_level_2">
<field name="funding_level_2" multiplicity="false">
		<field name="fundingid" indexId="fundinglevel2_id" label="">
			<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
		</field>
		<field name="fundingdescription" indexId="fundingprogramdescription" label="">
			<xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
		</field>
		<field name="fundingname" indexId="fundingprogramname" label="">
			<xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
		</field>
		<field name="fundingclass" indexId="" label="">
			<xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
		</field>
</field>
</xsl:template>

<xsl:template match="funding_level_1">
<field name="funding_level_1" multiplicity="false">
        <field name="fundingid" indexId="fundinglevel1_id" label="">
            <xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
        </field>
        <field name="fundingdescription" indexId="fundingstreamnamedescription" label="">
            <xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
        </field>
        <field name="fundingname" indexId="fundingstreamname" label="">
            <xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
        </field>
        <field name="fundingclass" indexId="" label="">
            <xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
		</field>
</field>
</xsl:template>

<xsl:template match="funding_level_0">
<field name="funding_level_0" multiplicity="false">
    <field name="fundingid" indexId="fundinglevel0_id" label="">
        <xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
    </field>
    <field name="fundingdescription" indexId="fundingstreamnamedescription" label="">
        <xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
    </field>
    <field name="fundingname" indexId="fundingstreamname" label="">
        <xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
    </field>
    <field name="fundingclass" indexId="" label="">
        <xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
    </field>
</field>
</xsl:template>


<!--xsl:template match="funding[parent[not(node())]]" >
	<field name='funding'>
		<xsl:choose>
				<xsl:when test="./class='ec:program'">	
					<field name = "fundingprogramid" indexId = "fundingprogramid" multiplicity="true">
						<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
						<field name="fundingid" indexId="fundingprogramid" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
						</field>
						<field name="fundingdescription" indexId="fundingprogramdescription" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
						</field>
						<field name="fundingname" indexId="fundingprogramname" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
						</field>
						<field name="fundingclass" indexId="" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
						</field>
						<xsl:apply-templates select="../.."/>
					</field>
				</xsl:when>
				<xsl:when test="./class='ec:specificprogram'">	
					<field name = "fundingspecificprogramid" indexId = "fundingspecificprogramid" multiplicity="true">
						<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
						<field name="fundingid" indexId="fundingspecificprogramid" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
						</field>
						<field name="fundingdescription" indexId="fundingspecificprogramdescription" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
						</field>
						<field name="fundingname" indexId="fundingspecificprogramname" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
						</field>
						<field name="fundingclass" indexId="" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
						</field>
						<xsl:apply-templates select="../.."/>
					</field>
				</xsl:when>
				<xsl:when test="./class='ec:frameworkprogram'">	
					<field name = "fundingframeworkprogramid" indexId = "fundingframeworkprogramid" multiplicity="true">
						<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
						<field name="fundingid" indexId="fundingframeworkprogramid" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
						</field>
						<field name="fundingdescription" indexId="fundingframeworkprogramdescription" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
						</field>
						<field name="fundingname" indexId="fundingframeworkprogramname" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
						</field>
						<field name="fundingclass" indexId="" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
						</field>
						<xsl:apply-templates select="../.."/>
					</field>
				</xsl:when>
				<xsl:when test="./class='wt:fundingStream'">	
					<field name = "fundingstreamid" indexId = "fundingstreamid" multiplicity="true">
						<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
						<field name="fundingid" indexId="fundingstreamid" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
						</field>
						<field name="fundingdescription" indexId="fundingstreamnamedescription" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
						</field>
						<field name="fundingname" indexId="fundingstreamname" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
						</field>
						<field name="fundingclass" indexId="" label="">
							<xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
						</field>
						<xsl:apply-templates select="../.."/>
					</field>
				</xsl:when>
			</xsl:choose>	
	</field>

</xsl:template>


<xsl:template match="@* | node()"></xsl:template>

<xsl:template match="funding[parent[node()]]">
	
	<xsl:choose>		
		<xsl:when test="./class='ec:program'">	
			<field name = "fundingprogramid" indexId = "fundingprogramid" multiplicity="true">
				<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
				<field name="fundingid" indexId="fundingprogramid" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
				</field>
				<field name="fundingdescription" indexId="fundingprogramdescription" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
				</field>
				<field name="fundingname" indexId="fundingprogramname" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
				</field>
				<field name="fundingclass" indexId="" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
				</field>
				<xsl:apply-templates select="../.."/>
			</field>
		</xsl:when>
		<xsl:when test="./class='ec:specificprogram'">	
			<field name = "fundingspecificprogramid" indexId = "fundingspecificprogramid" multiplicity="true">
				<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
				<field name="fundingid" indexId="fundingspecificprogramid" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
				</field>
				<field name="fundingdescription" indexId="fundingspecificprogramdescription" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
				</field>
				<field name="fundingname" indexId="fundingspecificprogramname" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
				</field>
				<field name="fundingclass" indexId="" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
				</field>
				<xsl:apply-templates select="../.."/>
			</field>
		</xsl:when>
		<xsl:when test="./class='ec:frameworkprogram'">	
			<field name = "fundingframeworkprogramid" indexId = "fundingframeworkprogramid" multiplicity="true">
				<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
				<field name="fundingid" indexId="fundingframeworkprogramid" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
				</field>
				<field name="fundingdescription" indexId="fundingframeworkprogramdescription" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
				</field>
				<field name="fundingname" indexId="fundingframeworkprogramname" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
				</field>
				<field name="fundingclass" indexId="" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
				</field>
				<xsl:apply-templates select="../.."/>
			</field>
		</xsl:when>
		<xsl:when test="./class='wt:fundingStream'">	
			<field name = "fundingstreamid" indexId = "fundingstreamid" multiplicity="true">
				<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
				<field name="fundingid" indexId="fundingstreamid" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./id"/> </xsl:attribute>
				</field>
				<field name="fundingdescription" indexId="fundingstreamnamedescription" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./description"/> </xsl:attribute>
				</field>
				<field name="fundingname" indexId="fundingstreamname" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./name"/> </xsl:attribute>
				</field>
				<field name="fundingclass" indexId="" label="">
					<xsl:attribute name="value"> <xsl:value-of select="./class"/> </xsl:attribute>
				</field>
				<xsl:apply-templates select="../.."/>
			</field>
		</xsl:when>
	</xsl:choose>
	
</xsl:template-->


</xsl:stylesheet>


