<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dri="http://www.driver-repository.eu/namespace/dri"
xmlns:oaf="http://namespace.openaire.eu/oaf"
xmlns:dc="http://purl.org/dc/elements/1.1/">
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>

<xsl:template match = "/">
<result type ="result">
	<xsl:apply-templates select="//header"/>
	<xsl:apply-templates select="//oaf:organization"/>
	<xsl:apply-templates select="//rel"/>
</result>
</xsl:template>

<!-- HEADER
fields in header:
1. dri:objIdentifier 		[objIdentifier]
2. dri:repositoryId			X
3. dri:dateOfCollection		X
-->
<xsl:template match = "header">
	<field name="organizationId" multiplicity="false" indexId="objIdentifier" label="Object id">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:objIdentifier'/>
		</xsl:attribute>
	</field>
	<!--<field name="repositoryId" multiplicity="false" indexId="???" label="???">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:repositoryId'/>
		</xsl:attribute>
	</field>-->
	<!--<field name="dateOfCollection" multiplicity="false" indexId="???" label="???">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:dateOfCollection'/>
		</xsl:attribute>
	</field>-->
</xsl:template>

<xsl:template match = "oaf:organization">

	<xsl:for-each select = "./legalshortname">		
		<field name="legalshortname" indexId = "organizationlegalshortname" multiplicity="true" label="Legal short name">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./legalname">
		<field name="legalname" indexId = "organizationlegalname" multiplicity="true" label="Legal name">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./websiteurl">
		<field name="websiteurl" indexId = "organizationwebsiteurl" multiplicity="true" label="Website url">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./country">
		<field name="countryid" indexId = "organizationcountryid" multiplicity="true" label="Country">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classid'/>
			</xsl:attribute>
		</field>
		<field name="countryname" indexId = "organizationcountryname" multiplicity="true" label="Country">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classname'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>


<!--
	
	<xsl:for-each select = "./logourl">
		<field name="logourl" indexId = "organizationlogourl" multiplicity="true" label="Logo url">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./eclegalbody">
		<field name="eclegalbody" indexId = "organizationeclegalbody" multiplicity="true" label="Eclegal body">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./eclegalperson">
		<field name="eclegalperson" indexId = "organizationeclegalperson" multiplicity="true" label="Eclegal person">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./ecnonprofit">
		<field name="ecnonprofit" indexId = "organizationecnonprofit" multiplicity="true" label="EC non profit">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./ecresearchorganization">
		<field name="ecresearchorganization" indexId = "organizationecresearchorganization" multiplicity="true" label="EC research organization">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./echighereducation">
		<field name="echighereducation" indexId = "" multiplicity="true" label="EC higher education">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./ecinternationalorganizationeurinterests">
		<field name="ecinternationalorganizationeurinterests" indexId = "organizationecinternationalorganizationeurinterests" multiplicity="true" label="EC international organization eur interests">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./ecinternationalorganization">
		<field name="ecinternationalorganization" indexId = "organizationecinternationalorganization" multiplicity="true" label="EC international organization">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./ecenterprise">
		<field name="ecenterprise" indexId = "organizationecenterprise" multiplicity="true" label="EC enterprice">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./ecsmevalidated">
		<field name="ecsmevalidated" indexId = "organizationecsmevalidated" multiplicity="true" label="EC sme validated">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./ecnutscode">
		<field name="ecnutscode" indexId = "organizationecnutscode" multiplicity="true" label="EC nuts code">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./collectedfrom">
		<field name="collectedfrom" indexId = "organizationcollectedfrom" multiplicity="true" label="Collected from">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>


	<xsl:for-each select = "./pid">
		<field name="pidid" indexId = "pidclassid" multiplicity="true" label="Pid">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classid'/>
			</xsl:attribute>
		</field>
		<field name="pidname" indexId = "pidclassname" multiplicity="true" label="Pid">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classname'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

-->
</xsl:template>

<xsl:template match="rel">
<!--PERSON-->
	<xsl:if test="./to/@type='person'">
		<field name="author" indexId = "objIdentifier"  multiplicity="true">
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "personId" indexId ="objIdentifier" multiplicity="false" label="Person id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "role" indexId ="" multiplicity="false" label="role">		
				<xsl:attribute name="value"><xsl:value-of select='./to/@class'/> </xsl:attribute>
			</field>
			<field name = "fullname" indexId ="personfullname" multiplicity="false" label="Person fullname">		
				<xsl:attribute name="value"><xsl:value-of select='./fullname'/> </xsl:attribute>
			</field>
			<field name = "ranking" indexId ="" multiplicity="false" label="ranking">		
				<xsl:attribute name="value"><xsl:value-of select='./ranking'/> </xsl:attribute>
			</field>
		</field>
	</xsl:if>
<!--PROJECT-->
	<xsl:if test="./to/@type='project'">	
		<field name="project" indexId = "objIdentifier" multiplicity="true">
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "projectId" indexId ="objIdentifier" multiplicity="false" label="Project id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "role" indexId ="" multiplicity="false" label="role">		
				<xsl:attribute name="value"><xsl:value-of select='./to/@class'/> </xsl:attribute>
			</field>
			<field name = "projectcode" indexId ="projectcode" multiplicity="false" label="Project(s)">		
				<xsl:attribute name="value"><xsl:value-of select='./code'/> </xsl:attribute>
			</field>	
			<field name = "projectacronym" indexId ="projectacronym" multiplicity="false" label="Project(s)">		
				<xsl:attribute name="value"><xsl:value-of select='./acronym'/> </xsl:attribute>
			</field>
			<field name = "projecttitle" indexId ="projecttitle" multiplicity="false" label="Project title">		
				<xsl:attribute name="value"><xsl:value-of select='./title'/> </xsl:attribute>
			</field>
			<field name = "projectcontracttypeid" indexId ="projectcontracttypeid" multiplicity="false" label="Project contract type id">		
				<xsl:attribute name="value"><xsl:value-of select='./contracttype/@classid'/> </xsl:attribute>
			</field>
			<field name = "projectcontracttypename" indexId ="projectcontracttypename" multiplicity="false" label="Project contract type name">		
				<xsl:attribute name="value"><xsl:value-of select='./contracttype/@classname'/> </xsl:attribute>
			</field>
		</field>
	</xsl:if>
<!--RESULT-->
	<xsl:if test="./to/@type='result'">
		<field name="result" indexId = "objIdentifier"  multiplicity="true">
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "resultid" indexId ="objIdentifier" multiplicity="false" label="Result id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "title" indexId = "resulttitle" multiplicity = "false" label = "Title">
				<xsl:attribute name="value">
					<xsl:value-of select="./title"/>
				</xsl:attribute>
			</field>
			<field name = "dateofacceptance" indexId = "resultdateofacceptance" multiplicity = "false" label = "Date of acceptance">
				<xsl:attribute name="value">
					<xsl:value-of select="./dateofacceptance"/>
				</xsl:attribute>
			</field>
			<field name = "resulttypeid" indexId = "resulttypeid" multiplicity = "false" label = "type id">
				<xsl:attribute name="value">
					<xsl:value-of select="./resulttype/@classid"/>
				</xsl:attribute>
			</field>
			<field name = "resulttypename" indexId = "resulttypename" multiplicity = "false" label = "type name">
				<xsl:attribute name="value">
					<xsl:value-of select="./resulttype/@classname"/>
				</xsl:attribute>
			</field>
		</field>
	</xsl:if>	
<!--ORGANIZATION-->
	<xsl:if test="./to/@type='organization'">
		<field name="organization" indexId = "objIdentifier"  multiplicity="true">
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "organizationid" indexId ="objIdentifier" multiplicity="false" label="Organization id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "role" indexId ="" multiplicity="false" label="role">		
				<xsl:attribute name="value"><xsl:value-of select='./to/@class'/> </xsl:attribute>
			</field>
			<field name = "legalshortname" indexId ="organizationlegalshortname" multiplicity="false" label="Organization short name">		
				<xsl:attribute name="value"><xsl:value-of select='./legalshortname'/> </xsl:attribute>
			</field>
			<field name = "websiteurl" indexId ="organizationwebsiteurl" multiplicity="false" label="Website">		
				<xsl:attribute name="value"><xsl:value-of select='./websiteurl'/> </xsl:attribute>
			</field>
			<field name = "countryid" indexId ="organizationcountryid" multiplicity="false" label="Country code">		
				<xsl:attribute name="value"><xsl:value-of select='./country/@classid'/> </xsl:attribute>
			</field>
			<field name = "countryname" indexId ="organizationcountryname" multiplicity="false" label="Country">		
				<xsl:attribute name="value"><xsl:value-of select='./country/@classname'/> </xsl:attribute>
			</field>
			<field name = "participantnumber" indexId ="" multiplicity="false" label="Participant Number">		
				<xsl:attribute name="value"><xsl:value-of select='./participantnumber'/> </xsl:attribute>
			</field>
			<field name = "contactperson" indexId ="" multiplicity="false" label="Contact Person">		
				<xsl:attribute name="value"><xsl:value-of select='./contactperson'/> </xsl:attribute>
			</field>
		</field>
	</xsl:if>

</xsl:template>

</xsl:stylesheet>


