<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dri="http://www.driver-repository.eu/namespace/dri"
xmlns:oaf="http://namespace.openaire.eu/oaf"
xmlns:dc="http://purl.org/dc/elements/1.1/">
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>
<xsl:template match = "/">
<result type ="result">
	<xsl:apply-templates select="//header"/>
	<xsl:apply-templates select="//oaf:result"/>
	<xsl:apply-templates select="//rel"/>
	<xsl:apply-templates select="//instances"/>
</result>
</xsl:template>

<xsl:template match = "header">
	<field name="resultId" multiplicity="false" indexId="objIdentifier" label="object id">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:objIdentifier'/>
		</xsl:attribute>
	</field>
</xsl:template>

<xsl:template match = "oaf:result">
	<xsl:for-each select = "./dc:title">		
		<field name="title" indexId = "title" multiplicity="true" label="Title">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./dc:creator">
		<field name="creator" indexId = "creator" multiplicity="true" label="Author(s)">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./dc:description">
		<field name="description" indexId = "description" multiplicity="true" label="Description">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./dc:publisher">
		<field name="publisher" indexId = "publisher" multiplicity="true" label="Publisher(s)">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./dc:identifier">
		<field name="identifier" indexId = "identifier" multiplicity="true" label="id"> 
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./dc:subject">
		<field name="subject" indexId = "subject" multiplicity="true" label="Subject(s)">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./dc:language">
		<field name="language" indexId = "language" multiplicity="true" label="Language">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:publicationdate">
		<field name="publicationdate" indexId = "publicationdate" multiplicity="true" label="Publication date">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:publicationyear">
		<field name="publicationyear" indexId = "publicationyear" multiplicity="true" label="Publication year">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:embargoenddate">
		<field name="embargoenddate" indexId = "embargoenddate" multiplicity="true" label="Embargo end date">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:embargoendyear">
		<field name="embargoendyear" indexId = "embargoendyear" multiplicity="true" label="Embargo end year">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:accessmode">
		<field name="accessmode" indexId = "accessmode" multiplicity="true" label="Access mode">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:haskind">
		<field name="haskind" indexId = "haskind" multiplicity="true" label="has kind">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>	
	<xsl:for-each select = "./oaf:hastype">
		<field name="hastype" indexId = "hastype" multiplicity="true" label="has type">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:affiliationid">
		<field name="affiliationid" indexId = "affiliationid" multiplicity="true" label="Affiliation">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:countryaffiliation">
		<field name="countryaffiliation" indexId = "countryaffiliation" multiplicity="true" label="Country">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:affiliationname">
		<field name="affiliationname" indexId = "affiliationname" multiplicity="true" label="Affiliation">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:aggregatedby">
		<field name="aggregatedby" indexId = "aggregatedby" multiplicity="true" label="Aggregated by">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:aggregatorname">
		<field name="aggregatorname" indexId = "aggregatorname" multiplicity="true" label="Aggregator(s)">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select = "./oaf:aggregatorurl">
		<field name="aggregatorurl" indexId = "aggregatorurl" multiplicity="true" label="Aggregator url">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>
	<xsl:for-each select="./bestlicense">
                <field name="bestlicense" indexId="resultbestlicense" multiplicity="false" label="Best license">
                        <xsl:attribute name="value">
                                <xsl:value-of select="./@classname"/>
                        </xsl:attribute>
                </field>
        </xsl:for-each>
</xsl:template>

<xsl:template match="rel">
	<xsl:if test="./to/@type='person'">
		<field name="author" indexId = ""  multiplicity="true">
			<field name = "personId" indexId ="" multiplicity="false" label="person">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "fullname" indexId ="" multiplicity="false" label="Person fullname">		
				<xsl:attribute name="value"><xsl:value-of select='./oaf:fullname'/> </xsl:attribute>
			</field>
		</field>
	</xsl:if>
	<xsl:if test="./to/@type='project'">	
		<field name="project" indexId = "" multiplicity="true">
			<field name = "projectgrantagreementnumber" indexId ="projectgrantagreementnumber" multiplicity="false" label="Project grant agreement number">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "projectname" indexId ="projectname" multiplicity="false" label="Project(s)">		
				<xsl:attribute name="value"><xsl:value-of select='./oaf:projectname'/> </xsl:attribute>
			</field>
		</field>
	</xsl:if>
</xsl:template>

<xsl:template match="instances">
	<xsl:for-each select = "./instance">
		<field name = "repository"  indexId = "" multiplicity="true">
			<field name = "instanceId" indexId = "objIdentifier" multiplicity = "false">
				<xsl:attribute name="value"><xsl:value-of select="./@id"/></xsl:attribute>
			</field>
			<field name = "repositoryname" indexId = "datasourcename" multiplicity="false">
				<xsl:attribute name = "value"> <xsl:value-of select="./datasource/oaf:datasourcename"/> </xsl:attribute>
			</field> 
			<field name = "repositoryid" indexId = "datasourceid" multiplicity="false">
				<xsl:attribute name = "value"> <xsl:value-of select="./datasource/oaf:datasourceid"/> </xsl:attribute>
			</field> 
			<xsl:for-each select="./webresource">
				<field name = "url" indexId = "dc:identifier" multiplicity="true">
					<xsl:attribute name = "value"> <xsl:value-of select="./dc:identifier"/> </xsl:attribute>
				</field> 
			</xsl:for-each>
		</field>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>

