<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dri="http://www.driver-repository.eu/namespace/dri"
xmlns:oaf="http://namespace.openaire.eu/oaf"
xmlns:dc="http://purl.org/dc/elements/1.1/">
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>
<xsl:template match="/">
<record type="project">
	<xsl:apply-templates select="/record/result/metadata/oaf:entity/oaf:project"/>
	<xsl:apply-templates select="/record/result/metadata/oaf:entity/oaf:project/children/organizations"/>
	<xsl:apply-templates select="/record/result/metadata/oaf:entity/oaf:project/rels/rel"/>
</record>
</xsl:template>

<xsl:template match = "oaf:project">
	<field name="projectid" label = "Project Id" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:projectid'/>
		</xsl:attribute>
	</field>
	<field name="projectname" label = "Project" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:projectname'/>
		</xsl:attribute>
	</field>
	<field name="projecttitle" label = "Title" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:projectdescription'/>
		</xsl:attribute>
	</field>
	<field name="projectcallid" label = "Call" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:projectcallid'/>
		</xsl:attribute>
	</field>
	<field name="projectgrantagreementnumber" label = "Grant agreement number" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:projectgrantagreementnumber'/>
		</xsl:attribute>
	</field>
	<field name="projectsc39" label = "Special Clause 39" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:choose>
				<xsl:when test = "./oaf:projectsc39 = 'true'">
					<xsl:text>yes</xsl:text>
				</xsl:when>
				<xsl:when test = "./oaf:projectsc39 = 'false'">
					<xsl:text>no</xsl:text>
				</xsl:when>
								
			</xsl:choose>
		</xsl:attribute>
	</field>
	<field name="projectstartdate" label = "Start date" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:variable name="datestr"><xsl:value-of select='./oaf:projectstartdate'/></xsl:variable>
			<xsl:value-of select="substring($datestr,9,2)"/>
			<xsl:value-of select="'/'"/>
			<xsl:value-of select="substring($datestr,6,2)"/>
			<xsl:value-of select="'/'"/>
			<xsl:value-of select="substring($datestr,1,4)"/>
		</xsl:attribute>
	</field>
	<field name="projectenddate" label = "End date" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:variable name="datestr"><xsl:value-of select='./oaf:projectenddate'/></xsl:variable>
			<xsl:value-of select="substring($datestr,9,2)"/>
			<xsl:value-of select="'/'"/>
			<xsl:value-of select="substring($datestr,6,2)"/>
			<xsl:value-of select="'/'"/>
			<xsl:value-of select="substring($datestr,1,4)"/>
		</xsl:attribute>
	</field>
	<field name="projectsubject" label = "Scientific area" indexId = "" multiplicity = "true">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:projectsubject'/>
		</xsl:attribute>
	</field>
	<field name="specificprogramname" label = "Programme" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:specificprogramname'/><xsl:text>-</xsl:text><xsl:value-of select='./oaf:specificprogramdescription'/>
		</xsl:attribute>
	</field>
			<!--		  SITES			-->
	<field name="projectsite" label = "Project site" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:projectsite'/>
		</xsl:attribute>
	</field>
	<field name="projectecsite" label = "Project ec site" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:projectecsite'/>
		</xsl:attribute>
	</field>


			<!--		 MORE INFO 		-->
	<field name="fundingschemename" label = "Funding scheme name" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:fundingschemename'/>
		</xsl:attribute>
	</field>
	<field name="fundingschemedescription" label = "Funding scheme description" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:fundingschemedescription'/>
		</xsl:attribute>
	</field>
	<field name="programid" label = "Program id" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:programid'/>
		</xsl:attribute>
	</field>
	<field name="programname" label = "Program name" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:programname'/>
		</xsl:attribute>
	</field>
	<field name="frameworkprogramid" label = "Framework program id" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:frameworkprogramid'/>
		</xsl:attribute>
	</field>
	<field name="frameworkprogramname" label = "Framework program name" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:frameworkprogramname'/>
		</xsl:attribute>
	</field>
	<field name="frameworkprogramdescription" label = "Framework program description" indexId = "" multiplicity = "false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:frameworkprogramdescription'/>
		</xsl:attribute>
	</field>
</xsl:template>

<xsl:template match = "organizations">
	<xsl:for-each select="./organization">
		<field name="organization" multiplicity="true">
			<field name = "organisationid" label="Organization Id" indexId="" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of	select="./@id"/>
				</xsl:attribute>
			</field>
			<field name = "legalname" label="Legal Name" indexId="" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of	select="./legal_name"/>
				</xsl:attribute>
			</field>
		</field>
	</xsl:for-each>
</xsl:template>

<xsl:template match = "rels/rel">
	<xsl:if test="./to/@class ='result'">
		<field name="publication" multiplicity="true">
			<field name = "resultId" label="resultId" indexId="" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of	select="./to"/>
				</xsl:attribute>
			</field>
			<xsl:for-each select="./dc:title"><field name = "title" label="Title" indexId="" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of	select="."/>
				</xsl:attribute>
			</field></xsl:for-each>
			<xsl:for-each select="./oaf:publicationyear"><field name = "publicationyear" label="Publication year" indexId="" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of	select="."/>
				</xsl:attribute>
			</field></xsl:for-each>
			<xsl:for-each select="./oaf:datasourcename"><field name = "datasourcename" label="Datasource name" indexId="" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of	select="."/>
				</xsl:attribute>
			</field></xsl:for-each>
			<xsl:for-each select="./oaf:datasourceid"><field name = "datasourceid" label="Datasource id" indexId="" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of	select="."/>
				</xsl:attribute>
			</field></xsl:for-each>
		</field>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
