<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dri="http://www.driver-repository.eu/namespace/dri"
xmlns:oaf="http://namespace.openaire.eu/oaf"
xmlns:dc="http://purl.org/dc/elements/1.1/">
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>
<xsl:template match="/">
<record type="person">
	<xsl:apply-templates select="/record/result/header"/>
	<xsl:apply-templates select="/record/result/metadata/oaf:entity/oaf:person"/>
	<xsl:apply-templates select="/record/result/metadata/oaf:entity/oaf:person/rels/rel"/>
</record>
</xsl:template>

<xsl:template match="header">
	<field name="personId" multiplicity="false">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:objIdentifier'/>
		</xsl:attribute>
		<xsl:attribute name="label">
			<xsl:text>personId</xsl:text>
		</xsl:attribute>
		<xsl:attribute name="indexId">
			<xsl:text>dri:objIdentifier</xsl:text>
		</xsl:attribute>
	</field>
</xsl:template>

<xsl:template match="oaf:person">
	<field name="fullname" multiplicity="false">
		<xsl:attribute name="value">
			<xsl:value-of select='./oaf:fullname'/>
		</xsl:attribute>
		<xsl:attribute name="label">
			<xsl:text>Fullname</xsl:text>
		</xsl:attribute>
		<xsl:attribute name="indexId">
		</xsl:attribute>
	</field>
</xsl:template>

<xsl:template match="rel">
	<field multiplicity="true">
		<xsl:attribute name="name">
			<xsl:value-of select='./to/@class'/>
		</xsl:attribute>
		<xsl:if test="./to/@type ='person'">
			<field name="personId" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of select='./to'/>
				</xsl:attribute>
				<xsl:attribute name="label">
					<xsl:text>personId</xsl:text>
				</xsl:attribute>
					<xsl:attribute name="indexId">
				</xsl:attribute>
			</field>
			<field name="fullname" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of select='./oaf:fullname'/>
				</xsl:attribute>
				<xsl:attribute name="label">
					<xsl:text>Fullname</xsl:text>
				</xsl:attribute>
					<xsl:attribute name="indexId">
				</xsl:attribute>
			</field>
		</xsl:if>
		
		<xsl:if test="./to/@type ='result'">
			<field name="resultId" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of select='./to'/>
				</xsl:attribute>
				<xsl:attribute name="label">
					<xsl:text>resultId</xsl:text>
				</xsl:attribute>
					<xsl:attribute name="indexId">
				</xsl:attribute>
			</field>
			<field name="title" multiplicity="true">
				<xsl:attribute name="value">
					<xsl:value-of select='./dc:title'/>
				</xsl:attribute>
				<xsl:attribute name="label">
					<xsl:text>Title</xsl:text>
				</xsl:attribute>
					<xsl:attribute name="indexId">
				</xsl:attribute>
			</field>
			<field name="publicationYear" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:value-of select='./oaf:publicationyear'/>
				</xsl:attribute>
				<xsl:attribute name="label">
					<xsl:text>Publication Year</xsl:text>
				</xsl:attribute>
					<xsl:attribute name="indexId">
				</xsl:attribute>
			</field>
		</xsl:if>

	</field>
</xsl:template>
</xsl:stylesheet>
