/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.web.servlet;

import eu.dnetlib.api.data.SearchService;
import eu.dnetlib.data.search.app.SearchServiceImpl;
import eu.dnetlib.domain.data.FormattedSearchResult;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.IncompleteArgumentException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SearchServlet
extends HttpServlet {
    private SearchServiceImpl searchService = null;
    private ApplicationContext context = null;
    private static Logger logger = Logger.getLogger(SearchService.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.searchService = (SearchServiceImpl)((Object)this.context.getBean("searchService"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        FormattedSearchResult formattedSearchResult = null;
        String action = request.getParameter("action");
        if (action == null) {
            throw new UnsupportedOperationException("Undefined action.");
        }
        String query = request.getParameter("query");
        if (query == null) {
            throw new IncompleteArgumentException("Undefined query. Search request");
        }
        String format = request.getParameter("format") != null ? request.getParameter("format") : "xml";
        String locale = request.getParameter("locale");
        int page = this.readParameter(request, "page", 1);
        int size = this.readParameter(request, "size", 10);
        String sTransformer = request.getParameter("sTransformer");
        String rTransformer = request.getParameter("rTransformer");
        Collection<String> fields = this.readParameter(request, "fields");
        response.setContentType("text/xml;charset=UTF-8");
        try {
            writer = response.getWriter();
            if (action.equals("search")) {
                if (sTransformer == null) {
                    throw new IncompleteArgumentException("Undefined search transformer. Search request");
                }
                formattedSearchResult = this.searchService.search(query, sTransformer, format, locale, page, size);
            } else if (action.equals("refine")) {
                if (rTransformer == null) {
                    throw new IncompleteArgumentException("Undefined refine transformer. Refine request");
                }
                if (fields == null) {
                    throw new IncompleteArgumentException("Undefined refine fields. Refine request");
                }
                formattedSearchResult = this.searchService.refine(query, rTransformer, format, locale, fields);
            } else if (action.equals("searchNrefine")) {
                if (sTransformer == null) {
                    throw new IncompleteArgumentException("Undefined search transformer. Search and Refine request");
                }
                if (rTransformer == null) {
                    throw new IncompleteArgumentException("Undefined refine transformer. Search and Refine request");
                }
                if (fields == null) {
                    throw new IncompleteArgumentException("Undefined refine fields. Search and Refine request");
                }
                formattedSearchResult = this.searchService.searchNrefine(query, sTransformer, rTransformer, format, locale, page, size, fields);
            } else {
                throw new UnsupportedOperationException("The action " + action + " is not supported.");
            }
            writer.append(formattedSearchResult.getFormattedResult());
        }
        catch (Exception e) {
            writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.append("<error>");
            writer.append("<exception>").append(StringEscapeUtils.escapeXml((String)e.getClass().getName())).append("</exception>");
            if (e.getMessage() != null) {
                writer.append("<message>").append(StringEscapeUtils.escapeXml((String)e.getMessage())).append("</message>");
            }
            if (e.getCause() != null) {
                writer.append("<cause>").append(StringEscapeUtils.escapeXml((String)e.getCause().toString())).append("</cause>");
            }
            StackTraceElement[] trace = e.getStackTrace();
            writer.append("<trace>");
            for (int i = 0; i < trace.length; ++i) {
                writer.append(StringEscapeUtils.escapeXml((String)trace[i].toString())).append("\n");
            }
            writer.append("</trace>");
            writer.append("</error>");
        }
        finally {
            writer.close();
        }
    }

    private Collection<String> readParameter(HttpServletRequest request, String parameterName) {
        ArrayList<String> fields = null;
        String[] paramfields = request.getParameterValues(parameterName);
        if (paramfields != null) {
            fields = new ArrayList<String>();
            for (int i = 0; i < paramfields.length; ++i) {
                fields.add(paramfields[i]);
            }
        }
        return fields;
    }

    public int readParameter(HttpServletRequest request, String parameterName, int defaultValue) {
        String param = request.getParameter(parameterName);
        return param != null ? Integer.parseInt(param) : defaultValue;
    }
}

