/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.web.api;

import eu.dnetlib.data.search.app.SearchServiceImpl;
import eu.dnetlib.data.search.utils.vocabulary.VocabularyManager;
import eu.dnetlib.data.search.web.api.QueryEnhancer;
import eu.dnetlib.domain.data.FormattedSearchResult;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.IncompleteArgumentException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SearchRequestController {
    @Autowired
    private SearchServiceImpl searchService = null;
    @Autowired
    private VocabularyManager vocabularyManager = null;
    @Resource
    private String maxResults = null;
    @Resource
    private String maxSize = null;
    private Logger logger = Logger.getLogger(SearchRequestController.class);
    private static final String XML_CONTENT_TYPE = "application/xml;charset=UTF-8";
    private static final String JSON_CONTENT_TYPE = "application/json;charset=UTF-8;";
    private static final String CSV_CONTENT_TYPE = "text/csv;charset=UTF-8;";
    private static final String TSV_CONTENT_TYPE = "text/tab-separated-values;charset=UTF-8;";
    private static final String HTML_CONTENT_TYPE = "text/html;charset=UTF-8;";
    private final String PUBLICATION_BASIC_QUERY = "(oaftype exact result) and (resulttypeid exact publication)";
    private final String DATASET_BASIC_QUERY = "(oaftype exact result) and (resulttypeid exact dataset)";
    private final String PROJECT_BASIC_QUERY = "(oaftype exact project)";
    private final List<String> GLOBAL_PARAMETERS = Arrays.asList("page", "size", "format", "sortBy");
    private final List<String> PUB_N_DATA_COMMON_PARAMETERS = Arrays.asList("author", "doi", "FP7ProjectID", "FP7scientificArea", "fromDateAccepted", "funder", "fundingStream", "hasECFunding", "hasProject", "hasUKFunding", "keywords", "model", "OA", "openaireAuthorID", "openaireProjectID", "openaireProviderID", "projectID", "title", "toDateAccepted");
    private final List<String> PUB_PARAMETERS = Arrays.asList("openairePublicationID");
    private final List<String> DATA_PARAMETERS = Arrays.asList("openaireDatasetID");
    private final List<String> PUB_N_DATASET_MODELS = Arrays.asList("dc", "openaire", "sygma");
    private final List<String> PUB_N_DATASET_FORMATS = Arrays.asList("json", "rss", "xml", "csv", "tsv", "html");
    private final List<String> PROJECT_PARAMETERS = Arrays.asList("acronym", "callID", "endYear", "FP7scientificArea", "funder", "fundingStream", "grantID", "hasECFunding", "hasUKFunding", "keywords", "name", "participantAcronyms", "participantCountries", "startYear");
    private final List<String> PROJECT_FORMATS = Arrays.asList("xml", "json");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public void search(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        FormattedSearchResult formattedSearchResult = null;
        String action = request.getParameter("action");
        if (action == null) {
            throw new UnsupportedOperationException("Undefined action.");
        }
        String query = request.getParameter("query");
        if (query == null) {
            throw new IncompleteArgumentException("Undefined query. Search request");
        }
        String format = request.getParameter("format") != null ? request.getParameter("format") : "xml";
        this.createResponseMeta(response, format, "UTF-8");
        String locale = request.getParameter("locale");
        int page = this.readParameter(request, "page", 1);
        int size = this.readParameter(request, "size", 10);
        if (size > Integer.parseInt(this.maxSize)) {
            throw new IllegalArgumentException("Size argument have exceeded the maximum allowed number.");
        }
        String sTransformer = request.getParameter("sTransformer");
        String rTransformer = request.getParameter("rTransformer");
        Collection<String> fields = this.readParameter(request, "fields");
        try {
            writer = response.getWriter();
            if (action.equals("search")) {
                if (sTransformer == null) {
                    throw new IncompleteArgumentException("Undefined search transformer. Search request");
                }
                formattedSearchResult = this.searchService.search(query, sTransformer, format, locale, page, size);
            } else if (action.equals("refine")) {
                if (rTransformer == null) {
                    throw new IncompleteArgumentException("Undefined refine transformer. Refine request");
                }
                if (fields == null) {
                    throw new IncompleteArgumentException("Undefined refine fields. Refine request");
                }
                formattedSearchResult = this.searchService.refine(query, rTransformer, format, locale, fields);
            } else if (action.equals("searchNrefine")) {
                if (sTransformer == null) {
                    throw new IncompleteArgumentException("Undefined search transformer. Search and Refine request");
                }
                if (rTransformer == null) {
                    throw new IncompleteArgumentException("Undefined refine transformer. Search and Refine request");
                }
                if (fields == null) {
                    throw new IncompleteArgumentException("Undefined refine fields. Search and Refine request");
                }
                formattedSearchResult = this.searchService.searchNrefine(query, sTransformer, rTransformer, format, locale, page, size, fields);
            } else {
                throw new UnsupportedOperationException("The action " + action + " is not supported. Please try one of {search, refine, searchNrefine}.");
            }
            writer.append(formattedSearchResult.getFormattedResult());
        }
        catch (Exception e) {
            this.logger.error((Object)"Fail to execute search.", (Throwable)e);
            this.createXmlErrorPage(writer, e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @RequestMapping(value={"/search/openSearchDescriptor"}, method={RequestMethod.GET})
    public String printOpenSearchDescriptor(ModelMap model) {
        return "openSearchDescriptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/publications"}, method={RequestMethod.GET})
    public void searchPublications(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            this.checkParameters(ListUtils.union(this.PUB_N_DATA_COMMON_PARAMETERS, this.PUB_PARAMETERS), request.getParameterMap());
            int page = this.readParameter(request, "page", 1);
            int size = this.readParameter(request, "size", 10);
            this.checkRequestSize(page, size);
            String format = request.getParameter("format") != null ? request.getParameter("format") : "xml";
            this.checkFormatParameter(this.PUB_N_DATASET_FORMATS, format);
            this.createResponseMeta(response, format, "UTF-8");
            String locale = request.getParameter("locale");
            String model = request.getParameter("model");
            SearchRequestController.checkModelParameter(this.PUB_N_DATASET_MODELS, model);
            String sTransformer = this.defineTransformer(model, format);
            String newFormat = this.defineFormatter(model, true);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("(oaftype exact result) and (resulttypeid exact publication)");
            QueryEnhancer.enhanceQueryWithFundingLevelParams(queryBuilder, request, this.vocabularyManager);
            QueryEnhancer.enhanceQueryWithOpenAIREIds(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithMetadataKeywords(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithFundingParams(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithRelProjectParams(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithAccessRights(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithDate(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithDoi(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithResultsSortParameters(queryBuilder, request);
            FormattedSearchResult formattedSearchResult = this.searchService.search(queryBuilder.toString(), sTransformer, newFormat != null ? newFormat : format, locale, page, size);
            writer.append(formattedSearchResult.getFormattedResult());
        }
        catch (Exception e) {
            this.logger.error((Object)"Fail to execute search.", (Throwable)e);
            this.createXmlErrorPage(writer, e);
        }
        finally {
            if (writer != null) {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/datasets"}, method={RequestMethod.GET})
    public void searchData(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            this.checkParameters(ListUtils.union(this.PUB_N_DATA_COMMON_PARAMETERS, this.DATA_PARAMETERS), request.getParameterMap());
            int page = this.readParameter(request, "page", 1);
            int size = this.readParameter(request, "size", 10);
            this.checkRequestSize(page, size);
            String format = request.getParameter("format") != null ? request.getParameter("format") : "xml";
            this.createResponseMeta(response, format, "UTF-8");
            this.checkFormatParameter(this.PUB_N_DATASET_FORMATS, format);
            String model = request.getParameter("model");
            SearchRequestController.checkModelParameter(this.PUB_N_DATASET_MODELS, model);
            String sTransformer = this.defineTransformer(model, format);
            String newFormat = this.defineFormatter(model, false);
            String locale = request.getParameter("locale");
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("(oaftype exact result) and (resulttypeid exact dataset)");
            QueryEnhancer.enhanceQueryWithFundingLevelParams(queryBuilder, request, this.vocabularyManager);
            QueryEnhancer.enhanceQueryWithOpenAIREIds(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithMetadataKeywords(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithFundingParams(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithRelProjectParams(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithAccessRights(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithDate(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithDoi(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithResultsSortParameters(queryBuilder, request);
            FormattedSearchResult formattedSearchResult = this.searchService.search(queryBuilder.toString(), sTransformer, newFormat != null ? newFormat : format, locale, page, size);
            writer.append(formattedSearchResult.getFormattedResult());
        }
        catch (Exception e) {
            this.logger.error((Object)"Fail to execute search.", (Throwable)e);
            this.createXmlErrorPage(writer, e);
        }
        finally {
            if (writer != null) {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/projects"}, method={RequestMethod.GET})
    public void searchProjects(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            this.checkParameters(this.PROJECT_PARAMETERS, request.getParameterMap());
            int page = this.readParameter(request, "page", 1);
            int size = this.readParameter(request, "size", 10);
            this.checkRequestSize(page, size);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("(oaftype exact project)");
            String locale = request.getParameter("locale");
            String format = request.getParameter("format") != null ? request.getParameter("format") : "xml";
            this.checkFormatParameter(this.PROJECT_FORMATS, format);
            this.createResponseMeta(response, format, "UTF-8");
            String sTransformer = request.getParameter("sTransformer");
            FormattedSearchResult formattedSearchResult = null;
            QueryEnhancer.enhanceQueryWithProjectMetadataKeywords(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithProjectFundingParams(queryBuilder, request);
            QueryEnhancer.enhanceProjectQueryWithFundingLevelParams(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithParticipantsInfoParams(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithYearParams(queryBuilder, request);
            QueryEnhancer.enhanceQueryWithProjectSortParameters(queryBuilder, request);
            formattedSearchResult = this.searchService.search(queryBuilder.toString(), sTransformer, format, locale, page, size);
            writer.append(formattedSearchResult.getFormattedResult());
        }
        catch (Exception e) {
            this.logger.error((Object)"Fail to execute search.", (Throwable)e);
            this.createXmlErrorPage(writer, e);
        }
        finally {
            if (writer != null) {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    private String defineTransformer(String model) {
        if (model != null && !model.trim().isEmpty()) {
            if (model.equals("openaire")) {
                return null;
            }
            if (model.equals("sygma")) {
                return "results_openaire";
            }
            if (model.equals("dc")) {
                return "dc";
            }
            throw new IllegalArgumentException("model '" + model + "' is not supported.");
        }
        return null;
    }

    private String defineTransformer(String model, String format) {
        if (model != null && !model.trim().isEmpty()) {
            if (model.equals("openaire")) {
                return null;
            }
            if (model.equals("sygma")) {
                return "results_openaire";
            }
            if (model.equals("dc")) {
                return "dc";
            }
            throw new IllegalArgumentException("model '" + model + "' is not supported.");
        }
        if (format != null && !format.trim().isEmpty() && (format.equals("rss") || format.equals("csv") || format.equals("tsv") || format.equals("html"))) {
            return "results_openaire";
        }
        return null;
    }

    private String defineFormatter(String model, boolean isPublications) {
        if (model != null && !model.trim().isEmpty() && model.equals("sygma")) {
            if (isPublications) {
                return "sygma_publication";
            }
            return "sygma_dataset";
        }
        return null;
    }

    private void createXmlErrorPage(PrintWriter writer, Exception e) {
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.append("<error>");
        writer.append("<exception>").append(StringEscapeUtils.escapeXml((String)e.getClass().getName())).append("</exception>");
        if (e.getMessage() != null) {
            writer.append("<message>").append(StringEscapeUtils.escapeXml((String)e.getMessage())).append("</message>");
        }
        if (e.getCause() != null) {
            writer.append("<cause>").append(StringEscapeUtils.escapeXml((String)e.getCause().toString())).append("</cause>");
        }
        StackTraceElement[] trace = e.getStackTrace();
        writer.append("<trace>");
        for (int i = 0; i < trace.length; ++i) {
            writer.append(StringEscapeUtils.escapeXml((String)trace[i].toString())).append("\n");
        }
        writer.append("</trace>");
        writer.append("</error>");
    }

    public int readParameter(HttpServletRequest request, String parameterName, int defaultValue) {
        String param = request.getParameter(parameterName);
        return param != null && !param.isEmpty() ? Integer.parseInt(param) : defaultValue;
    }

    private Collection<String> readParameter(HttpServletRequest request, String parameterName) {
        ArrayList<String> fields = null;
        String[] paramfields = request.getParameterValues(parameterName);
        if (paramfields != null) {
            fields = new ArrayList<String>();
            for (int i = 0; i < paramfields.length; ++i) {
                fields.add(paramfields[i]);
            }
        }
        return fields;
    }

    private void checkRequestSize(int page, int size) {
        int total = page * size;
        if (total > Integer.parseInt(this.maxResults)) {
            throw new IllegalArgumentException("Size and page arguments have exceeded the maximum number of returned results.");
        }
    }

    private String defineContentType(String format) {
        if (format != null) {
            if (format.toLowerCase().equals("xml")) {
                return XML_CONTENT_TYPE;
            }
            if (format.toLowerCase().equals("json")) {
                return JSON_CONTENT_TYPE;
            }
            if (format.toLowerCase().equals("csv")) {
                return CSV_CONTENT_TYPE;
            }
            if (format.toLowerCase().equals("tsv")) {
                return TSV_CONTENT_TYPE;
            }
            if (format.toLowerCase().equals("html")) {
                return HTML_CONTENT_TYPE;
            }
        }
        return XML_CONTENT_TYPE;
    }

    private void checkParameters(List<String> allowedParameters, Map<String, String[]> currentParameters) {
        if (currentParameters != null) {
            for (String parameter : currentParameters.keySet()) {
                if (allowedParameters.contains(parameter) || this.GLOBAL_PARAMETERS.contains(parameter)) continue;
                throw new IllegalArgumentException("Parameter " + parameter + " is not supported. The supported parameters are: " + allowedParameters.toString().replace("[", "").replace("]", ", ") + this.GLOBAL_PARAMETERS.toString().substring(1, this.GLOBAL_PARAMETERS.toString().length() - 1));
            }
        }
    }

    private void checkFormatParameter(List<String> allowedFormats, String requestedFormat) {
        if (requestedFormat != null && !allowedFormats.contains(requestedFormat)) {
            throw new IllegalArgumentException("The requested format '" + requestedFormat + "' is not supported. The supported formats are: " + allowedFormats);
        }
    }

    private static void checkModelParameter(List<String> allowedModels, String requestedModel) {
        if (requestedModel != null && !allowedModels.contains(requestedModel)) {
            throw new IllegalArgumentException("The requested model '" + allowedModels + "' is not supported. The supported formats are: " + allowedModels);
        }
    }

    private void createResponseMeta(HttpServletResponse response, String format, String encoding) {
        response.setContentType(this.defineContentType(format));
        response.setCharacterEncoding("UTF-8");
        if (!format.equals("xml") || !format.equals("json")) {
            SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
            String date = sdf.format(new Date());
            if (format.equals("csv")) {
                response.setHeader("Content-Disposition", "filename=" + date + ".csv");
            } else if (format.equals("csv")) {
                response.setHeader("Content-Disposition", "filename=" + date + ".tsv");
            } else if (format.equals("html")) {
                response.setHeader("Content-Disposition", "filename=" + date + ".html");
            }
        }
    }
}

