/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.web.api;

import eu.dnetlib.data.search.utils.vocabulary.VocabularyManager;
import eu.dnetlib.domain.enabling.Vocabulary;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class QueryEnhancer {
    private static final Logger logger = Logger.getLogger(QueryEnhancer.class);

    public static void enhanceQueryWithFundingLevelParams(StringBuilder queryBuilder, HttpServletRequest request, VocabularyManager vocabularyManager) {
        String funder = request.getParameter("funder");
        String fundingStream = request.getParameter("fundingStream");
        String FP7scientificArea = request.getParameter("FP7scientificArea");
        if (funder != null) {
            QueryEnhancer.addExactQueryTerm("relfundinglevel0_id", funder.toUpperCase(), queryBuilder);
        }
        if (fundingStream != null && !fundingStream.trim().isEmpty()) {
            Vocabulary relfundinglevel1Vocabulary = vocabularyManager.getVocabulary("programmes_simple", Locale.ROOT);
            queryBuilder.append(" and (relfundinglevel1_id exact \"").append(QueryEnhancer.devocabularizedTerm(fundingStream, relfundinglevel1Vocabulary)).append("\")");
        }
        if (FP7scientificArea != null && !FP7scientificArea.trim().isEmpty()) {
            Vocabulary relfundinglevel2Vocabulary = vocabularyManager.getVocabulary("areas", Locale.ROOT);
            queryBuilder.append(" and (relfundinglevel2_id exact \"").append(QueryEnhancer.devocabularizedTerm(FP7scientificArea, relfundinglevel2Vocabulary)).append("\")");
        }
    }

    public static void enhanceProjectQueryWithFundingLevelParams(StringBuilder queryBuilder, HttpServletRequest request) {
        String funder = request.getParameter("funder");
        String fundingStream = request.getParameter("fundingStream");
        String FP7scientificArea = request.getParameter("FP7scientificArea");
        if (funder != null) {
            QueryEnhancer.addExactQueryTerm("fundinglevel0_name", funder.toUpperCase(), queryBuilder);
        }
        if (fundingStream != null && !fundingStream.trim().isEmpty()) {
            QueryEnhancer.addExactQueryTerm("fundinglevel1_name", fundingStream.toUpperCase(), queryBuilder);
        }
        if (FP7scientificArea != null && !FP7scientificArea.trim().isEmpty()) {
            QueryEnhancer.addExactQueryTerm("fundinglevel2_name", FP7scientificArea.toUpperCase(), queryBuilder);
        }
    }

    public static void enhanceQueryWithFundingParams(StringBuilder queryBuilder, HttpServletRequest request) {
        String hasECFunding = request.getParameter("hasECFunding");
        String hasUKFunding = request.getParameter("hasUKFunding");
        QueryEnhancer.addBooleanQueryTerm("contextid", hasECFunding, "ec", queryBuilder);
        QueryEnhancer.addBooleanQueryTerm("contextid", hasUKFunding, "uk", queryBuilder);
    }

    public static void enhanceQueryWithProjectFundingParams(StringBuilder queryBuilder, HttpServletRequest request) {
        String hasECFunding = request.getParameter("hasECFunding");
        String hasUKFunding = request.getParameter("hasUKFunding");
        QueryEnhancer.addBooleanQueryTerm("fundinglevel0_id", hasECFunding, "corda_______::FP7", queryBuilder);
        QueryEnhancer.addBooleanQueryTerm("fundinglevel0_id", hasUKFunding, "wt::WT", queryBuilder);
    }

    public static void enhanceQueryWithRelProjectParams(StringBuilder queryBuilder, HttpServletRequest request) {
        String hasProject = request.getParameter("hasProject");
        String projectID = request.getParameter("projectID");
        String FP7ProjectID = request.getParameter("FP7ProjectID");
        if (hasProject != null && !hasProject.isEmpty()) {
            if (hasProject.equals("true")) {
                QueryEnhancer.addEqualQueryTerm("relprojectid", "*", queryBuilder);
            } else {
                QueryEnhancer.addNotEqualQueryTerm("relprojectid", "*", queryBuilder);
            }
        }
        if (FP7ProjectID != null && !FP7ProjectID.trim().isEmpty()) {
            QueryEnhancer.addExactQueryTerm("relprojectcode", FP7ProjectID, queryBuilder);
            QueryEnhancer.addExactQueryTerm(" relfundinglevel0_id", "FP7", queryBuilder);
        }
        if (projectID != null && !projectID.trim().isEmpty()) {
            queryBuilder.append(" and (relprojectcode exact \"").append(projectID).append("\")");
        }
    }

    public static void enhanceQueryWithAccessRights(StringBuilder queryBuilder, HttpServletRequest request) {
        String oa = request.getParameter("OA");
        QueryEnhancer.addBooleanQueryTerm("resultbestlicense", oa, "Open Access", queryBuilder);
    }

    public static void enhanceQueryWithDate(StringBuilder queryBuilder, HttpServletRequest request) throws IllegalArgumentException {
        String fromDateAccepted = request.getParameter("fromDateAccepted");
        String toDateAccepted = request.getParameter("toDateAccepted");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setLenient(false);
        if (toDateAccepted != null && !toDateAccepted.isEmpty() && (fromDateAccepted == null || fromDateAccepted.isEmpty())) {
            if (!QueryEnhancer.checkDate(toDateAccepted, simpleDateFormat)) {
                throw new IllegalArgumentException("toDateAccepted date must be formatted as YYYY-MM-DD");
            }
            fromDateAccepted = "*";
        }
        if (fromDateAccepted != null && !fromDateAccepted.isEmpty() && (toDateAccepted == null || toDateAccepted.isEmpty())) {
            if (!QueryEnhancer.checkDate(fromDateAccepted, simpleDateFormat)) {
                throw new IllegalArgumentException("fromDateAccepted date must be formatted as YYYY-MM-DD");
            }
            toDateAccepted = simpleDateFormat.format(new Date());
        }
        if (toDateAccepted != null && !toDateAccepted.isEmpty() && fromDateAccepted != null && !fromDateAccepted.isEmpty()) {
            queryBuilder.append(" and (resultdateofacceptance within \"").append(fromDateAccepted).append(" ").append(toDateAccepted).append("\")");
        }
    }

    public static void enhanceQueryWithYearParams(StringBuilder queryBuilder, HttpServletRequest request) {
        String startYear = request.getParameter("startYear");
        String endYear = request.getParameter("endYear");
        int sYear = -1;
        if (startYear != null && !startYear.isEmpty()) {
            try {
                sYear = Integer.parseInt(startYear);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("startYear parameter must be a numeric value.");
            }
        }
        int eYear = -1;
        if (endYear != null && !endYear.isEmpty()) {
            try {
                eYear = Integer.parseInt(endYear);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("endYear parameter must be a numeric value.");
            }
        }
        if (eYear != -1 && sYear != -1 && eYear < sYear) {
            throw new IllegalArgumentException("endYear must be greater than startYear.");
        }
        QueryEnhancer.addExactQueryTerm("projectstartyear", startYear, queryBuilder);
        QueryEnhancer.addExactQueryTerm("projectendyear", endYear, queryBuilder);
    }

    public static void enhanceQueryWithResultsSortParameters(StringBuilder queryBuilder, HttpServletRequest request) {
        String sortByParameter = request.getParameter("sortBy");
        if (sortByParameter != null) {
            String[] sortParams = sortByParameter.split(",");
            if (sortParams.length != 2) {
                throw new IllegalArgumentException("Invalid sort paremeter. 'sortBy' parameter format is <fieldName>[,ascending|,descending].");
            }
            String sortByField = sortParams[0];
            String order = sortParams[1];
            if (!QueryEnhancer.checkPublicationSortParameterFields(sortByField)) {
                throw new IllegalArgumentException("'" + sortByField + "' is not a sortable field.");
            }
            if (!QueryEnhancer.checkOrder(order)) {
                throw new IllegalArgumentException("'" + order + "' is not a valid ordering. Please use one of {ascending, descending}");
            }
            QueryEnhancer.addSortParameter(sortByField, order, queryBuilder);
        }
    }

    public static void enhanceQueryWithProjectSortParameters(StringBuilder queryBuilder, HttpServletRequest request) {
        String sortByParameter = request.getParameter("sortBy");
        if (sortByParameter != null) {
            String[] sortParams = sortByParameter.split(",");
            if (sortParams.length != 2) {
                throw new IllegalArgumentException("Invalid sort paremeter. 'sortBy' parameter format is <fieldName>[,ascending|,descending].");
            }
            String sortByField = sortParams[0];
            String order = sortParams[1];
            if (!QueryEnhancer.checkProjectSortParameterFields(sortByField)) {
                throw new IllegalArgumentException("'" + sortByField + "' is not a sortable field.");
            }
            if (!QueryEnhancer.checkOrder(order)) {
                throw new IllegalArgumentException("'" + order + "' is not a valid ordering. Please use one of {ascending, descending}");
            }
            QueryEnhancer.addSortParameter(sortByField, order, queryBuilder);
        }
    }

    private static boolean checkPublicationSortParameterFields(String sortField) {
        return sortField != null && !sortField.isEmpty() && sortField.matches("dateofcollection|resultstoragedate|resultembargoenddate|resultembargoendyear|resulttypeid|resulttypename|resultlanguageid|resultlanguagename|resultbestlicense|resultbestlicenseid|resultdateofacceptance|resultacceptanceyear");
    }

    private static boolean checkProjectSortParameterFields(String sortField) {
        return sortField != null && !sortField.isEmpty() && sortField.matches("dateofcollection|projectstartdate|projectstartyear|projectenddate|projectendyear|projectcallidentifier|projectduration|projectecsc39|projectcontracttypeid|projectcontracttypename");
    }

    private static boolean checkOrder(String order) {
        return order.matches("ascending|descending");
    }

    public static boolean checkDate(String date, SimpleDateFormat simpleDateFormat) {
        try {
            simpleDateFormat.parse(date);
        }
        catch (ParseException pe) {
            logger.warn((Object)"Wrong date format.", (Throwable)pe);
            return false;
        }
        return true;
    }

    public static void enhanceQueryWithOpenAIREIds(StringBuilder queryBuilder, HttpServletRequest request) {
        String[] openairePublicationIDs = request.getParameterValues("openairePublicationID");
        String[] openaireDatasetIDs = request.getParameterValues("openaireDatasetID");
        String[] openaireAuthorIDs = request.getParameterValues("openaireAuthorID");
        String[] openaireProviderIDs = request.getParameterValues("openaireProviderID");
        String[] openaireProjectIDs = request.getParameterValues("openaireProjectID");
        QueryEnhancer.enhanceQueryWithIds("objidentifier", openairePublicationIDs, queryBuilder);
        QueryEnhancer.enhanceQueryWithIds("objidentifier", openaireDatasetIDs, queryBuilder);
        QueryEnhancer.enhanceQueryWithIds("relpersonid", openaireAuthorIDs, queryBuilder);
        QueryEnhancer.enhanceQueryWithIds("resulthostingdatasourceid", openaireProviderIDs, queryBuilder);
        QueryEnhancer.enhanceQueryWithIds("relprojectid", openaireProjectIDs, queryBuilder);
    }

    public static void enhanceQueryWithMetadataKeywords(StringBuilder queryBuilder, HttpServletRequest request) {
        String keywords = request.getParameter("keywords");
        String title = request.getParameter("title");
        String author = request.getParameter("author");
        QueryEnhancer.addMetadataQueryTerm(null, keywords, queryBuilder);
        QueryEnhancer.addMetadataQueryTerm("resulttitle", title, queryBuilder);
        QueryEnhancer.addMetadataQueryTerm("relperson", author, queryBuilder);
    }

    public static void enhanceQueryWithProjectMetadataKeywords(StringBuilder queryBuilder, HttpServletRequest request) {
        String keywords = request.getParameter("keywords");
        String acronym = request.getParameter("acronym");
        String name = request.getParameter("name");
        String grantID = request.getParameter("grantID");
        String callID = request.getParameter("callID");
        QueryEnhancer.addMetadataQueryTerm(null, keywords, queryBuilder);
        QueryEnhancer.addMetadataQueryTerm("projectacronym", acronym, queryBuilder);
        QueryEnhancer.addEqualQueryTerm("projecttitle", name, queryBuilder);
        QueryEnhancer.addExactQueryTerm("projectcode", grantID, queryBuilder);
        QueryEnhancer.addExactQueryTerm("projectcallidentifier", callID, queryBuilder);
    }

    public static void enhanceQueryWithParticipantsInfoParams(StringBuilder queryBuilder, HttpServletRequest request) {
        String[] participantCountries = request.getParameterValues("participantCountries");
        String participantAcronyms = request.getParameter("participantAcronyms");
        if (participantCountries != null) {
            QueryEnhancer.enhanceQueryWithCommaSeparatedValues("relorganizationcountryid", participantCountries, queryBuilder);
        }
        QueryEnhancer.addORQueryTerm("relorganizationname", "relorganizationshortname", participantAcronyms, queryBuilder);
    }

    public static void enhanceQueryWithDoi(StringBuilder queryBuilder, HttpServletRequest request) {
        String[] dois = request.getParameterValues("doi");
        if (dois != null && dois.length != 0) {
            queryBuilder.append(" and ");
            for (int i = 0; i < dois.length; ++i) {
                String[] commaSeparated = dois[i].split(",");
                for (int j = 0; j < commaSeparated.length; ++j) {
                    queryBuilder.append("(pidclassid exact \"doi\" and pid exact \"").append(commaSeparated[j]).append("\")");
                    if (i >= dois.length - 1 && j >= commaSeparated.length - 1) continue;
                    queryBuilder.append(" or ");
                }
            }
        }
    }

    public static void enhanceQueryWithIds(String idIndexFieldName, String[] ids, StringBuilder queryBuilder) {
        if (ids != null && ids.length != 0) {
            queryBuilder.append(" and ");
            for (int i = 0; i < ids.length; ++i) {
                String[] commaSeparated = ids[i].split(",");
                for (int j = 0; j < commaSeparated.length; ++j) {
                    queryBuilder.append("(" + idIndexFieldName + " exact \"").append(commaSeparated[j]).append("\")");
                    if (i >= ids.length - 1 && j >= commaSeparated.length - 1) continue;
                    queryBuilder.append(" or ");
                }
            }
        }
    }

    public static void enhanceQueryWithCommaSeparatedValues(String indexFieldName, String[] fieldValues, StringBuilder queryBuilder) {
        if (fieldValues != null && fieldValues.length != 0) {
            queryBuilder.append(" and ");
            for (int i = 0; i < fieldValues.length; ++i) {
                String[] commaSeparated = fieldValues[i].split(",");
                for (int j = 0; j < commaSeparated.length; ++j) {
                    queryBuilder.append("(").append(indexFieldName).append(" exact \"").append(commaSeparated[j].toUpperCase()).append("\")");
                    if (i >= fieldValues.length - 1 && j >= commaSeparated.length - 1) continue;
                    queryBuilder.append(" and ");
                }
            }
        }
    }

    public static void addMetadataQueryTerm(String indexFieldName, String fieldValue, StringBuilder queryBuilder) {
        if (fieldValue != null && !fieldValue.trim().isEmpty()) {
            if (indexFieldName != null) {
                for (String term : fieldValue.trim().split(" ")) {
                    queryBuilder.append(" and (").append(indexFieldName).append(" = ").append(term).append(")");
                }
            } else {
                queryBuilder.append(" and ( ");
                String[] keywords = fieldValue.trim().split(" ");
                for (int i = 0; i < keywords.length; ++i) {
                    if (i == keywords.length - 1) {
                        queryBuilder.append(keywords[i]);
                        continue;
                    }
                    queryBuilder.append(keywords[i]).append(" and ");
                }
                queryBuilder.append(")");
            }
        }
    }

    public static void addORQueryTerm(String indexFieldName1, String indexFieldName2, String fieldValue, StringBuilder queryBuilder) {
        if (fieldValue != null && !fieldValue.trim().isEmpty()) {
            for (String term : fieldValue.trim().split(" ")) {
                queryBuilder.append(" and (" + indexFieldName1 + " = " + term + " or  " + indexFieldName2 + " = " + term + ")");
            }
        }
    }

    public static void addBooleanQueryTerm(String indexFieldName, String requestValue, String fieldValue, StringBuilder queryBuilder) {
        if (requestValue != null && !requestValue.trim().isEmpty()) {
            if (requestValue.trim().equals("true")) {
                QueryEnhancer.addExactQueryTerm(indexFieldName, fieldValue, queryBuilder);
            } else {
                QueryEnhancer.addDifferentEqualQueryTerm(indexFieldName, fieldValue, queryBuilder);
            }
        }
    }

    public static void addExactQueryTerm(String indexFieldName, String fieldValue, StringBuilder queryBuilder) {
        if (fieldValue != null && !fieldValue.trim().isEmpty()) {
            queryBuilder.append(" and (" + indexFieldName + " exact \"" + fieldValue + "\")");
        }
    }

    public static void addEqualQueryTerm(String indexFieldName, String fieldValue, StringBuilder queryBuilder) {
        if (fieldValue != null && !fieldValue.trim().isEmpty()) {
            queryBuilder.append(" and (" + indexFieldName + " = \"" + fieldValue.replaceAll("\"", "") + "\")");
        }
    }

    public static void addNotEqualQueryTerm(String indexFieldName, String fieldValue, StringBuilder queryBuilder) {
        if (fieldValue != null && !fieldValue.trim().isEmpty()) {
            queryBuilder.append(" not ").append(indexFieldName).append(" = \"").append(fieldValue).append("\"");
        }
    }

    public static void addDifferentEqualQueryTerm(String indexFieldName, String fieldValue, StringBuilder queryBuilder) {
        if (fieldValue != null && !fieldValue.trim().isEmpty()) {
            queryBuilder.append(" and (").append(indexFieldName).append(" <> \"").append(fieldValue).append("\")");
        }
    }

    public static void addVocabularizedQueryTerm(String indexFieldName, String fieldValue, StringBuilder queryBuilder, Vocabulary vocabulary) {
        if (fieldValue != null && !fieldValue.trim().isEmpty()) {
            queryBuilder.append(" and (").append(indexFieldName).append(" exact \"").append(QueryEnhancer.devocabularizedTerm(fieldValue, vocabulary)).append("\")");
        }
    }

    private static void addSortParameter(String indexField, String order, StringBuilder queryBuilder) {
        queryBuilder.append(" sortBy " + indexField + "/sort." + order);
    }

    public static String devocabularizedTerm(String value, Vocabulary vocabulary) {
        if (vocabulary != null) {
            String term = vocabulary.getEncoding(value);
            if (term == null) {
                return value;
            }
            return term;
        }
        return value;
    }
}

