/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.utils.vocabulary;

import eu.dnetlib.data.search.utils.vocabulary.LocalVocabulary;
import eu.dnetlib.data.search.utils.vocabulary.Vocabulary;
import eu.dnetlib.data.search.utils.vocabulary.VocabularyLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class LocalVocabularyLoader
extends VocabularyLoader {
    private static final Logger logger = Logger.getLogger(LocalVocabularyLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVocabularyXml(Vocabulary vocabulary, Locale locale) {
        logger.debug((Object)("Getting vocabulary with name " + vocabulary.getName() + " and locale " + locale));
        String xml = null;
        StringTokenizer tokenizer = new StringTokenizer(((LocalVocabulary)vocabulary).getFileName(), ".");
        String localizedVocabularyName = tokenizer.nextToken() + "_" + locale.getLanguage() + "_" + locale.getCountry() + "." + tokenizer.nextToken();
        InputStream xmlInputStream = this.getClass().getClassLoader().getResourceAsStream(localizedVocabularyName);
        if (xmlInputStream == null) {
            logger.debug((Object)("The " + localizedVocabularyName + " does not exist in classpath. Loading default vocabulary instead."));
            xmlInputStream = this.getClass().getClassLoader().getResourceAsStream(((LocalVocabulary)vocabulary).getFileName());
        }
        if (xmlInputStream == null) {
            logger.warn((Object)("The " + ((LocalVocabulary)vocabulary).getFileName() + " does not exist in classpath."));
            return xml;
        }
        try {
            xml = IOUtils.toString((InputStream)xmlInputStream);
        }
        catch (IOException ioe) {
            logger.debug((Object)("Problem loading " + localizedVocabularyName + " from classpath"), (Throwable)ioe);
        }
        finally {
            IOUtils.closeQuietly((InputStream)xmlInputStream);
        }
        return xml;
    }
}

