/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.utils.vocabulary;

import eu.dnetlib.api.data.SearchService;
import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.data.search.utils.vocabulary.IndexVocabulary;
import eu.dnetlib.data.search.utils.vocabulary.Vocabulary;
import eu.dnetlib.data.search.utils.vocabulary.VocabularyLoader;
import eu.dnetlib.domain.data.FormattedSearchResult;
import gr.uoa.di.driver.util.ServiceLocator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class IndexVocabularyLoader
extends VocabularyLoader {
    private ServiceLocator<SearchService> searchServiceLocator = null;
    private String localeCountry = null;
    private String localeLanguage = null;
    private static final int REQUEST_SIZE = 100;
    private Logger logger = Logger.getLogger(IndexVocabularyLoader.class);

    @Override
    public String getVocabularyXml(Vocabulary vocabulary, Locale locale) {
        this.logger.debug((Object)("Getting vocabulary with name " + vocabulary.getName() + " and locale " + locale));
        String xml = null;
        FormattedSearchResult fsr = null;
        try {
            fsr = ((SearchService)this.searchServiceLocator.getService()).search(((IndexVocabulary)vocabulary).getQuery(), ((IndexVocabulary)vocabulary).getTransformer(), "vocabulary", null, 1, 100);
            int totalResultNumber = fsr.getResultsNumber();
            if (totalResultNumber > 100) {
                fsr = ((SearchService)this.searchServiceLocator.getService()).search(((IndexVocabulary)vocabulary).getQuery(), ((IndexVocabulary)vocabulary).getTransformer(), "vocabulary", null, 1, totalResultNumber);
            }
            xml = fsr.getFormattedResult();
        }
        catch (SearchServiceException sse) {
            this.logger.error((Object)"Error getting Vocabulary xml", (Throwable)sse);
        }
        return xml;
    }

    public ServiceLocator<SearchService> getSearchServiceLocator() {
        return this.searchServiceLocator;
    }

    public void setSearchServiceLocator(ServiceLocator<SearchService> searchServiceLocator) {
        this.searchServiceLocator = searchServiceLocator;
    }
}

